/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.widget.dialog;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.ui.widget.dialog.AbstractFormDialog;
import org.wicketstuff.jquery.ui.widget.dialog.DialogButton;
import org.wicketstuff.jquery.ui.widget.dialog.DialogButtons;
import org.wicketstuff.jquery.ui.widget.dialog.DialogIcon;

public abstract class MessageFormDialog
extends AbstractFormDialog<String> {
    private static final long serialVersionUID = 1L;
    private Component label;
    private List<DialogButton> buttons;
    private final WebMarkupContainer container;

    public MessageFormDialog(String id, String title, String message, DialogButtons buttons) {
        this(id, title, message, buttons.toList(), DialogIcon.NONE);
    }

    public MessageFormDialog(String id, String title, String message, List<DialogButton> buttons) {
        this(id, title, message, buttons, DialogIcon.NONE);
    }

    public MessageFormDialog(String id, String title, String message, DialogButtons buttons, DialogIcon icon) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), (IModel<String>)Model.of((Serializable)((Object)message)), buttons.toList(), icon);
    }

    public MessageFormDialog(String id, String title, String message, List<DialogButton> buttons, DialogIcon icon) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), (IModel<String>)Model.of((Serializable)((Object)message)), buttons, icon);
    }

    public MessageFormDialog(String id, IModel<String> title, IModel<String> message, DialogButtons buttons) {
        this(id, title, message, buttons.toList(), DialogIcon.NONE);
    }

    public MessageFormDialog(String id, IModel<String> title, IModel<String> message, List<DialogButton> buttons) {
        this(id, title, message, buttons, DialogIcon.NONE);
    }

    public MessageFormDialog(String id, IModel<String> title, IModel<String> message, DialogButtons buttons, DialogIcon icon) {
        this(id, title, message, buttons.toList(), icon);
    }

    public MessageFormDialog(String id, IModel<String> title, IModel<String> message, List<DialogButton> buttons, DialogIcon icon) {
        super(id, title, message, true);
        this.buttons = (List)Args.notNull(buttons, (String)"buttons");
        this.container = new WebMarkupContainer("container");
        this.add(new Component[]{this.container});
        this.container.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)icon.getStyle()))});
        this.container.add(new Component[]{new EmptyPanel("icon").add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)icon))})});
    }

    @Override
    protected final List<DialogButton> getButtons() {
        return this.buttons;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.label = this.newLabel("message", (IModel<String>)this.getModel());
        this.container.add(new Component[]{this.label.setOutputMarkupId(true)});
    }

    @Override
    protected void onOpen(IPartialPageRequestHandler handler) {
        handler.add(new Component[]{this.label});
    }

    @Override
    public void onClose(IPartialPageRequestHandler handler, DialogButton button) {
    }

    protected Component newLabel(String id, IModel<String> model) {
        return new Label(id, model);
    }
}

