/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class TopicAddMessageListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 262656;
    public static final int RESPONSE_MESSAGE_TYPE = 262657;
    private static final int REQUEST_LOCAL_ONLY_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 17;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 30;
    private static final int EVENT_TOPIC_PUBLISH_TIME_FIELD_OFFSET = 16;
    private static final int EVENT_TOPIC_UUID_FIELD_OFFSET = 24;
    private static final int EVENT_TOPIC_INITIAL_FRAME_SIZE = 41;
    private static final int EVENT_TOPIC_MESSAGE_TYPE = 262658;

    private TopicAddMessageListenerCodec() {
    }

    public static ClientMessage encodeRequest(String name, boolean localOnly) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Topic.AddMessageListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 262656);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, localOnly);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.localOnly = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[30], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 262657);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 13, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static UUID decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator.next();
        return FixedSizeTypesCodec.decodeUUID(initialFrame.content, 13);
    }

    public static ClientMessage encodeTopicEvent(Data item, long publishTime, UUID uuid) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[41], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 262658);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, publishTime);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 24, uuid);
        clientMessage.add(initialFrame);
        DataCodec.encode(clientMessage, item);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public boolean localOnly;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 262658) {
                ClientMessage.Frame initialFrame = iterator.next();
                long publishTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
                UUID uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 24);
                Data item = DataCodec.decode(iterator);
                this.handleTopicEvent(item, publishTime, uuid);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleTopicEvent(Data var1, long var2, UUID var4);
    }
}

