/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.config.MergePolicyConfig;

public final class MergePolicyConfigCodec {
    private static final int BATCH_SIZE_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private MergePolicyConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, MergePolicyConfig mergePolicyConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, mergePolicyConfig.getBatchSize());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, mergePolicyConfig.getPolicy());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static MergePolicyConfig decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int batchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        String policy = StringCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new MergePolicyConfig(policy, batchSize);
    }
}

