/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCResetQueueAgeStatisticsCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.collection.impl.queue.QueueService;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.permission.ManagementPermission;
import java.security.Permission;

public class QueueResetAgeStatisticsMessageTask
extends AbstractCallableMessageTask<String> {
    private static final Permission REQUIRED_PERMISSION = new ManagementPermission("queue.resetAgeMetrics");

    public QueueResetAgeStatisticsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        QueueService service = (QueueService)this.getService(this.getServiceName());
        service.resetAgeStats((String)this.parameters);
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return REQUIRED_PERMISSION;
    }

    @Override
    protected String decodeClientMessage(ClientMessage clientMessage) {
        return MCResetQueueAgeStatisticsCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MCResetQueueAgeStatisticsCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    public String getDistributedObjectName() {
        return (String)this.parameters;
    }

    @Override
    public String getMethodName() {
        return "resetQueueAgeStatistics";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.parameters};
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

