/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AutoDetectionConfig;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.AzureConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.EurekaConfig;
import com.hazelcast.config.GcpConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class JoinConfig {
    private MulticastConfig multicastConfig = new MulticastConfig();
    private TcpIpConfig tcpIpConfig = new TcpIpConfig();
    private AwsConfig awsConfig = new AwsConfig();
    private GcpConfig gcpConfig = new GcpConfig();
    private AzureConfig azureConfig = new AzureConfig();
    private KubernetesConfig kubernetesConfig = new KubernetesConfig();
    private EurekaConfig eurekaConfig = new EurekaConfig();
    private DiscoveryConfig discoveryConfig = new DiscoveryConfig();
    private AutoDetectionConfig autoDetectionConfig = new AutoDetectionConfig();

    public MulticastConfig getMulticastConfig() {
        return this.multicastConfig;
    }

    public JoinConfig setMulticastConfig(MulticastConfig multicastConfig) {
        this.multicastConfig = Preconditions.isNotNull(multicastConfig, "multicastConfig");
        return this;
    }

    public TcpIpConfig getTcpIpConfig() {
        return this.tcpIpConfig;
    }

    public JoinConfig setTcpIpConfig(TcpIpConfig tcpIpConfig) {
        this.tcpIpConfig = Preconditions.isNotNull(tcpIpConfig, "tcpIpConfig");
        return this;
    }

    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    public JoinConfig setAwsConfig(AwsConfig awsConfig) {
        this.awsConfig = Preconditions.isNotNull(awsConfig, "awsConfig");
        return this;
    }

    public GcpConfig getGcpConfig() {
        return this.gcpConfig;
    }

    public JoinConfig setGcpConfig(GcpConfig gcpConfig) {
        this.gcpConfig = Preconditions.isNotNull(gcpConfig, "gcpConfig");
        return this;
    }

    public AzureConfig getAzureConfig() {
        return this.azureConfig;
    }

    public JoinConfig setAzureConfig(AzureConfig azureConfig) {
        this.azureConfig = Preconditions.isNotNull(azureConfig, "azureConfig");
        return this;
    }

    public KubernetesConfig getKubernetesConfig() {
        return this.kubernetesConfig;
    }

    public JoinConfig setKubernetesConfig(KubernetesConfig kubernetesConfig) {
        this.kubernetesConfig = Preconditions.isNotNull(kubernetesConfig, "kubernetesConfig");
        return this;
    }

    public EurekaConfig getEurekaConfig() {
        return this.eurekaConfig;
    }

    public JoinConfig setEurekaConfig(EurekaConfig eurekaConfig) {
        this.eurekaConfig = Preconditions.isNotNull(eurekaConfig, "eurekaConfig");
        return this;
    }

    public DiscoveryConfig getDiscoveryConfig() {
        return this.discoveryConfig;
    }

    public JoinConfig setDiscoveryConfig(DiscoveryConfig discoveryConfig) {
        this.discoveryConfig = Preconditions.isNotNull(discoveryConfig, "discoveryProvidersConfig");
        return this;
    }

    public AutoDetectionConfig getAutoDetectionConfig() {
        return this.autoDetectionConfig;
    }

    public JoinConfig setAutoDetectionConfig(AutoDetectionConfig autoDetectionConfig) {
        this.autoDetectionConfig = Preconditions.isNotNull(autoDetectionConfig, "autoDetectionConfig");
        return this;
    }

    public boolean isAutoDetectionEnabled() {
        return this.autoDetectionConfig.isEnabled() && !this.multicastConfig.isEnabled() && !this.tcpIpConfig.isEnabled() && !this.awsConfig.isEnabled() && !this.gcpConfig.isEnabled() && !this.azureConfig.isEnabled() && !this.kubernetesConfig.isEnabled() && !this.eurekaConfig.isEnabled() && !this.discoveryConfig.isEnabled();
    }

    public void verify() {
        Collection<DiscoveryStrategyConfig> discoveryStrategyConfigs;
        ArrayList<String> enabledDiscoveries = new ArrayList<String>();
        int countEnabled = 0;
        if (this.getTcpIpConfig().isEnabled()) {
            ++countEnabled;
            enabledDiscoveries.add("TCP/IP");
        }
        if (this.getMulticastConfig().isEnabled()) {
            ++countEnabled;
            enabledDiscoveries.add("Multicast");
        }
        if (this.getAwsConfig().isEnabled()) {
            ++countEnabled;
            enabledDiscoveries.add("AWS discovery");
        }
        if (this.getGcpConfig().isEnabled()) {
            ++countEnabled;
            enabledDiscoveries.add("GCP discovery");
        }
        if (this.getAzureConfig().isEnabled()) {
            ++countEnabled;
            enabledDiscoveries.add("Azure discovery");
        }
        if (this.getKubernetesConfig().isEnabled()) {
            ++countEnabled;
            enabledDiscoveries.add("Kubernetes discovery");
        }
        if (this.getEurekaConfig().isEnabled()) {
            ++countEnabled;
            enabledDiscoveries.add("Eureka discovery");
        }
        if (!(discoveryStrategyConfigs = this.discoveryConfig.getDiscoveryStrategyConfigs()).isEmpty()) {
            ++countEnabled;
            enabledDiscoveries.add("Discovery SPI");
        }
        if (countEnabled > 1) {
            throw new InvalidConfigurationException("Only one discovery method can be enabled at a time. Keep only one of the following method enabled by removing the others from the configuration, or setting enabled to 'false': " + String.join((CharSequence)", ", enabledDiscoveries));
        }
    }

    public String toString() {
        return "JoinConfig{multicastConfig=" + this.multicastConfig + ", tcpIpConfig=" + this.tcpIpConfig + ", awsConfig=" + this.awsConfig + ", gcpConfig=" + this.gcpConfig + ", azureConfig=" + this.azureConfig + ", kubernetesConfig=" + this.kubernetesConfig + ", eurekaConfig=" + this.eurekaConfig + ", discoveryConfig=" + this.discoveryConfig + ", autoDetectionConfig=" + this.autoDetectionConfig + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinConfig that = (JoinConfig)o;
        return Objects.equals(this.multicastConfig, that.multicastConfig) && Objects.equals(this.tcpIpConfig, that.tcpIpConfig) && Objects.equals(this.awsConfig, that.awsConfig) && Objects.equals(this.gcpConfig, that.gcpConfig) && Objects.equals(this.azureConfig, that.azureConfig) && Objects.equals(this.kubernetesConfig, that.kubernetesConfig) && Objects.equals(this.eurekaConfig, that.eurekaConfig) && Objects.equals(this.discoveryConfig, that.discoveryConfig) && Objects.equals(this.autoDetectionConfig, that.autoDetectionConfig);
    }

    public int hashCode() {
        return Objects.hash(this.multicastConfig, this.tcpIpConfig, this.awsConfig, this.gcpConfig, this.azureConfig, this.kubernetesConfig, this.eurekaConfig, this.discoveryConfig, this.autoDetectionConfig);
    }
}

