/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.record;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Date;
import java.util.List;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.entity.record.RecordingChunk;
import org.apache.openmeetings.db.util.DaoHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class RecordingChunkDao {
    private static final Logger log = LoggerFactory.getLogger(RecordingChunkDao.class);
    private static final String PARAM_RECID = "recordingId";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private RecordingDao recordingDao;

    public RecordingChunk get(Long id) {
        return (RecordingChunk)DaoHelper.only(this.em.createNamedQuery("getChunkById", RecordingChunk.class).setParameter("id", (Object)id).getResultList());
    }

    public List<RecordingChunk> getByRecording(Long recordingId) {
        return this.em.createNamedQuery("getChunkByRecording", RecordingChunk.class).setParameter(PARAM_RECID, (Object)recordingId).getResultList();
    }

    public List<RecordingChunk> getNotScreenChunksByRecording(Long recordingId) {
        return this.em.createNamedQuery("getNotScreenChunkByRecording", RecordingChunk.class).setParameter(PARAM_RECID, (Object)recordingId).setParameter("screen", (Object)RecordingChunk.Type.SCREEN).setParameter("none", (Object)RecordingChunk.Status.NONE).getResultList();
    }

    public RecordingChunk getScreenByRecording(Long recordingId) {
        List list = this.em.createNamedQuery("getScreenChunkByRecording", RecordingChunk.class).setParameter("screen", (Object)RecordingChunk.Type.SCREEN).setParameter(PARAM_RECID, (Object)recordingId).getResultList();
        return list.isEmpty() ? null : (RecordingChunk)list.get(0);
    }

    public Long start(Long recordingId, RecordingChunk.Type type, String streamName, String sid) {
        RecordingChunk chunk = new RecordingChunk();
        chunk.setRecording(this.recordingDao.get(recordingId));
        chunk.setStart(new Date());
        chunk.setType(type);
        chunk.setStreamName(streamName);
        chunk.setStreamStatus(RecordingChunk.Status.STARTED);
        chunk.setSid(sid);
        chunk = this.update(chunk);
        return chunk.getId();
    }

    public void stop(Long chunkId) {
        RecordingChunk chunk = this.get(chunkId);
        if (chunk != null) {
            chunk.setEnd(new Date());
            chunk.setStreamStatus(RecordingChunk.Status.STOPPED);
            this.update(chunk);
        }
    }

    public RecordingChunk update(RecordingChunk chunk) {
        log.debug("[update]: ");
        if (chunk.getId() == null) {
            this.em.persist((Object)chunk);
        } else {
            chunk = (RecordingChunk)this.em.merge((Object)chunk);
        }
        return chunk;
    }
}

