/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.room;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.openmeetings.db.dto.room.Whiteboard;

public class Whiteboards
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long roomId;
    private final String uid = UUID.randomUUID().toString();
    private Map<Long, Whiteboard> boards = new ConcurrentHashMap<Long, Whiteboard>();
    private AtomicLong whiteboardId = new AtomicLong(0L);
    private AtomicLong activeWb = new AtomicLong(0L);

    public Whiteboards() {
    }

    public Whiteboards(Long roomId) {
        this.roomId = roomId;
    }

    public Long getRoomId() {
        return this.roomId;
    }

    public void setRoomId(Long roomId) {
        this.roomId = roomId;
    }

    public Whiteboards add(Whiteboard wb) {
        wb.setId(this.whiteboardId.getAndIncrement());
        this.boards.put(wb.getId(), wb);
        return this;
    }

    public Whiteboard get(Long id) {
        return this.boards.get(id);
    }

    public int count() {
        return this.boards.size();
    }

    public Map<Long, Whiteboard> getWhiteboards() {
        return this.boards;
    }

    public void setWhiteboards(Map<Long, Whiteboard> whiteboards) {
        this.boards = whiteboards;
    }

    public void update(Whiteboard wb) {
        this.boards.put(wb.getId(), wb);
    }

    public String getUid() {
        return this.uid;
    }

    public long getActiveWb() {
        return this.activeWb.get();
    }

    public void setActiveWb(long wbId) {
        this.activeWb.set(wbId);
    }
}

