/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal.backwardsCompatibility.bridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.asteriskjava.lock.LockableMap;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.manager.event.BridgeEnterEvent;
import org.asteriskjava.manager.event.BridgeEvent;
import org.asteriskjava.manager.event.BridgeLeaveEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.internal.backwardsCompatibility.bridge.BridgeEnterEventComparator;
import org.asteriskjava.util.DateUtil;

class BridgeState {
    private static final BridgeEnterEventComparator BRIDGE_ENTER_EVENT_COMPARATOR = new BridgeEnterEventComparator();
    private static final String HOLDING_BRIDGE_TECH = "holding_bridge";
    private final LockableMap<String, BridgeEnterEvent> members = new LockableMap(new HashMap());

    BridgeState() {
    }

    ManagerEvent destroy() {
        try (Locker.LockCloser closer = this.members.withLock();){
            this.members.clear();
        }
        return null;
    }

    ManagerEvent addMember(BridgeEnterEvent event) {
        ArrayList<BridgeEnterEvent> remaining = null;
        if (HOLDING_BRIDGE_TECH.equals(event.getBridgeTechnology())) {
            return null;
        }
        try (Locker.LockCloser closer = this.members.withLock();){
            if (this.members.put(event.getChannel(), event) == null && this.members.size() == 2) {
                remaining = new ArrayList<BridgeEnterEvent>(this.members.values());
            }
        }
        if (remaining == null) {
            return null;
        }
        BridgeEvent bridgeEvent = this.buildBridgeEvent("Link", remaining);
        return bridgeEvent;
    }

    ManagerEvent removeMember(BridgeLeaveEvent event) {
        LinkedList<BridgeEnterEvent> remaining = new LinkedList<BridgeEnterEvent>();
        if (HOLDING_BRIDGE_TECH.equals(event.getBridgeTechnology())) {
            return null;
        }
        try (Locker.LockCloser closer = this.members.withLock();){
            remaining.addAll(this.members.values());
            if (this.members.remove(event.getChannel()) != null && remaining.size() == 2) {
                BridgeEvent bridgeEvent = this.buildBridgeEvent("Unlink", remaining);
                return bridgeEvent;
            }
        }
        return null;
    }

    private BridgeEvent buildBridgeEvent(String bridgeState, List<BridgeEnterEvent> members) {
        Collections.sort(members, BRIDGE_ENTER_EVENT_COMPARATOR);
        BridgeEvent bridgeEvent = new BridgeEvent(this);
        bridgeEvent.setCallerId1(members.get(0).getCallerIdNum());
        bridgeEvent.setUniqueId1(members.get(0).getUniqueId());
        bridgeEvent.setChannel1(members.get(0).getChannel());
        bridgeEvent.setCallerId2(members.get(1).getCallerIdNum());
        bridgeEvent.setUniqueId2(members.get(1).getUniqueId());
        bridgeEvent.setChannel2(members.get(1).getChannel());
        bridgeEvent.setBridgeState(bridgeState);
        bridgeEvent.setDateReceived(DateUtil.getDate());
        return bridgeEvent;
    }
}

