/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client;

import org.kurento.client.Handler;
import org.kurento.client.KurentoClient;
import org.kurento.client.Properties;
import org.kurento.client.ReconnectedHandler;

public class KurentoClientBuilder {
    private Properties properties;
    private String kmsWsUri;
    private Handler connectedHandler;
    private Handler connectionFailedHandler;
    private Handler disconnectedHandler;
    private ReconnectedHandler reconnectedHandler;
    private Handler reconnectingHandler;
    private Long tryReconnectingMaxTime;
    private Long connectionTimeout;

    public KurentoClientBuilder setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public KurentoClientBuilder setKmsWsUri(String kmsWsUri) {
        this.kmsWsUri = kmsWsUri;
        return this;
    }

    public KurentoClientBuilder onConnected(Handler connectedHandler) {
        this.connectedHandler = connectedHandler;
        return this;
    }

    public KurentoClientBuilder onConnectionFailed(Handler connectionFailedHandler) {
        this.connectionFailedHandler = connectionFailedHandler;
        return this;
    }

    public KurentoClientBuilder onDisconnected(Handler disconnectedHandler) {
        this.disconnectedHandler = disconnectedHandler;
        return this;
    }

    public KurentoClientBuilder onReconnecting(Handler reconnectingHandler) {
        this.reconnectingHandler = reconnectingHandler;
        return this;
    }

    public KurentoClientBuilder onReconnected(ReconnectedHandler reconnectedHandler) {
        this.reconnectedHandler = reconnectedHandler;
        return this;
    }

    public KurentoClientBuilder setTryReconnectingMaxTime(Long tryReconnectingMaxTime) {
        this.tryReconnectingMaxTime = tryReconnectingMaxTime;
        return this;
    }

    public KurentoClientBuilder setConnectionTimeout(Long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public KurentoClient connect() {
        return KurentoClient.create(this.kmsWsUri, this.properties, this.connectedHandler, this.connectionFailedHandler, this.reconnectingHandler, this.disconnectedHandler, this.reconnectedHandler, this.tryReconnectingMaxTime, this.connectionTimeout);
    }
}

