/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAverageValue is the corresponding interface of BACnetConstructedDataAverageValue
type BACnetConstructedDataAverageValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetAverageValue returns AverageValue (property field)
	GetAverageValue() BACnetApplicationTagReal
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagReal
	// IsBACnetConstructedDataAverageValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAverageValue()
	// CreateBuilder creates a BACnetConstructedDataAverageValueBuilder
	CreateBACnetConstructedDataAverageValueBuilder() BACnetConstructedDataAverageValueBuilder
}

// _BACnetConstructedDataAverageValue is the data-structure of this message
type _BACnetConstructedDataAverageValue struct {
	BACnetConstructedDataContract
	AverageValue BACnetApplicationTagReal
}

var _ BACnetConstructedDataAverageValue = (*_BACnetConstructedDataAverageValue)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAverageValue)(nil)

// NewBACnetConstructedDataAverageValue factory function for _BACnetConstructedDataAverageValue
func NewBACnetConstructedDataAverageValue(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, averageValue BACnetApplicationTagReal, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAverageValue {
	if averageValue == nil {
		panic("averageValue of type BACnetApplicationTagReal for BACnetConstructedDataAverageValue must not be nil")
	}
	_result := &_BACnetConstructedDataAverageValue{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		AverageValue:                  averageValue,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAverageValueBuilder is a builder for BACnetConstructedDataAverageValue
type BACnetConstructedDataAverageValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(averageValue BACnetApplicationTagReal) BACnetConstructedDataAverageValueBuilder
	// WithAverageValue adds AverageValue (property field)
	WithAverageValue(BACnetApplicationTagReal) BACnetConstructedDataAverageValueBuilder
	// WithAverageValueBuilder adds AverageValue (property field) which is build by the builder
	WithAverageValueBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataAverageValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAverageValue or returns an error if something is wrong
	Build() (BACnetConstructedDataAverageValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAverageValue
}

// NewBACnetConstructedDataAverageValueBuilder() creates a BACnetConstructedDataAverageValueBuilder
func NewBACnetConstructedDataAverageValueBuilder() BACnetConstructedDataAverageValueBuilder {
	return &_BACnetConstructedDataAverageValueBuilder{_BACnetConstructedDataAverageValue: new(_BACnetConstructedDataAverageValue)}
}

type _BACnetConstructedDataAverageValueBuilder struct {
	*_BACnetConstructedDataAverageValue

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataAverageValueBuilder) = (*_BACnetConstructedDataAverageValueBuilder)(nil)

func (b *_BACnetConstructedDataAverageValueBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAverageValue
}

func (b *_BACnetConstructedDataAverageValueBuilder) WithMandatoryFields(averageValue BACnetApplicationTagReal) BACnetConstructedDataAverageValueBuilder {
	return b.WithAverageValue(averageValue)
}

func (b *_BACnetConstructedDataAverageValueBuilder) WithAverageValue(averageValue BACnetApplicationTagReal) BACnetConstructedDataAverageValueBuilder {
	b.AverageValue = averageValue
	return b
}

func (b *_BACnetConstructedDataAverageValueBuilder) WithAverageValueBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataAverageValueBuilder {
	builder := builderSupplier(b.AverageValue.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.AverageValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataAverageValueBuilder) Build() (BACnetConstructedDataAverageValue, error) {
	if b.AverageValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'averageValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataAverageValue.deepCopy(), nil
}

func (b *_BACnetConstructedDataAverageValueBuilder) MustBuild() BACnetConstructedDataAverageValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAverageValueBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAverageValueBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAverageValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAverageValueBuilder().(*_BACnetConstructedDataAverageValueBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataAverageValueBuilder creates a BACnetConstructedDataAverageValueBuilder
func (b *_BACnetConstructedDataAverageValue) CreateBACnetConstructedDataAverageValueBuilder() BACnetConstructedDataAverageValueBuilder {
	if b == nil {
		return NewBACnetConstructedDataAverageValueBuilder()
	}
	return &_BACnetConstructedDataAverageValueBuilder{_BACnetConstructedDataAverageValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAverageValue) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAverageValue) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_AVERAGE_VALUE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAverageValue) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAverageValue) GetAverageValue() BACnetApplicationTagReal {
	return m.AverageValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataAverageValue) GetActualValue() BACnetApplicationTagReal {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagReal(m.GetAverageValue())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAverageValue(structType any) BACnetConstructedDataAverageValue {
	if casted, ok := structType.(BACnetConstructedDataAverageValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAverageValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAverageValue) GetTypeName() string {
	return "BACnetConstructedDataAverageValue"
}

func (m *_BACnetConstructedDataAverageValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (averageValue)
	lengthInBits += m.AverageValue.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataAverageValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAverageValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAverageValue BACnetConstructedDataAverageValue, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAverageValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAverageValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	averageValue, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "averageValue", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'averageValue' field"))
	}
	m.AverageValue = averageValue

	actualValue, err := ReadVirtualField[BACnetApplicationTagReal](ctx, "actualValue", (*BACnetApplicationTagReal)(nil), averageValue)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAverageValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAverageValue")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAverageValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAverageValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAverageValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAverageValue")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "averageValue", m.GetAverageValue(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'averageValue' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAverageValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAverageValue")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAverageValue) IsBACnetConstructedDataAverageValue() {}

func (m *_BACnetConstructedDataAverageValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAverageValue) deepCopy() *_BACnetConstructedDataAverageValue {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAverageValueCopy := &_BACnetConstructedDataAverageValue{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.AverageValue),
	}
	_BACnetConstructedDataAverageValueCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAverageValueCopy
}

func (m *_BACnetConstructedDataAverageValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
