/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataBBMDAcceptFDRegistrations is the corresponding interface of BACnetConstructedDataBBMDAcceptFDRegistrations
type BACnetConstructedDataBBMDAcceptFDRegistrations interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetBbmdAcceptFDRegistrations returns BbmdAcceptFDRegistrations (property field)
	GetBbmdAcceptFDRegistrations() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
	// IsBACnetConstructedDataBBMDAcceptFDRegistrations is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataBBMDAcceptFDRegistrations()
	// CreateBuilder creates a BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder
	CreateBACnetConstructedDataBBMDAcceptFDRegistrationsBuilder() BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder
}

// _BACnetConstructedDataBBMDAcceptFDRegistrations is the data-structure of this message
type _BACnetConstructedDataBBMDAcceptFDRegistrations struct {
	BACnetConstructedDataContract
	BbmdAcceptFDRegistrations BACnetApplicationTagBoolean
}

var _ BACnetConstructedDataBBMDAcceptFDRegistrations = (*_BACnetConstructedDataBBMDAcceptFDRegistrations)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataBBMDAcceptFDRegistrations)(nil)

// NewBACnetConstructedDataBBMDAcceptFDRegistrations factory function for _BACnetConstructedDataBBMDAcceptFDRegistrations
func NewBACnetConstructedDataBBMDAcceptFDRegistrations(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, bbmdAcceptFDRegistrations BACnetApplicationTagBoolean, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataBBMDAcceptFDRegistrations {
	if bbmdAcceptFDRegistrations == nil {
		panic("bbmdAcceptFDRegistrations of type BACnetApplicationTagBoolean for BACnetConstructedDataBBMDAcceptFDRegistrations must not be nil")
	}
	_result := &_BACnetConstructedDataBBMDAcceptFDRegistrations{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		BbmdAcceptFDRegistrations:     bbmdAcceptFDRegistrations,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder is a builder for BACnetConstructedDataBBMDAcceptFDRegistrations
type BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(bbmdAcceptFDRegistrations BACnetApplicationTagBoolean) BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder
	// WithBbmdAcceptFDRegistrations adds BbmdAcceptFDRegistrations (property field)
	WithBbmdAcceptFDRegistrations(BACnetApplicationTagBoolean) BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder
	// WithBbmdAcceptFDRegistrationsBuilder adds BbmdAcceptFDRegistrations (property field) which is build by the builder
	WithBbmdAcceptFDRegistrationsBuilder(func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataBBMDAcceptFDRegistrations or returns an error if something is wrong
	Build() (BACnetConstructedDataBBMDAcceptFDRegistrations, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataBBMDAcceptFDRegistrations
}

// NewBACnetConstructedDataBBMDAcceptFDRegistrationsBuilder() creates a BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder
func NewBACnetConstructedDataBBMDAcceptFDRegistrationsBuilder() BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder {
	return &_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder{_BACnetConstructedDataBBMDAcceptFDRegistrations: new(_BACnetConstructedDataBBMDAcceptFDRegistrations)}
}

type _BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder struct {
	*_BACnetConstructedDataBBMDAcceptFDRegistrations

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder) = (*_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder)(nil)

func (b *_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataBBMDAcceptFDRegistrations
}

func (b *_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder) WithMandatoryFields(bbmdAcceptFDRegistrations BACnetApplicationTagBoolean) BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder {
	return b.WithBbmdAcceptFDRegistrations(bbmdAcceptFDRegistrations)
}

func (b *_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder) WithBbmdAcceptFDRegistrations(bbmdAcceptFDRegistrations BACnetApplicationTagBoolean) BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder {
	b.BbmdAcceptFDRegistrations = bbmdAcceptFDRegistrations
	return b
}

func (b *_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder) WithBbmdAcceptFDRegistrationsBuilder(builderSupplier func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder {
	builder := builderSupplier(b.BbmdAcceptFDRegistrations.CreateBACnetApplicationTagBooleanBuilder())
	var err error
	b.BbmdAcceptFDRegistrations, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder) Build() (BACnetConstructedDataBBMDAcceptFDRegistrations, error) {
	if b.BbmdAcceptFDRegistrations == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'bbmdAcceptFDRegistrations' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataBBMDAcceptFDRegistrations.deepCopy(), nil
}

func (b *_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder) MustBuild() BACnetConstructedDataBBMDAcceptFDRegistrations {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataBBMDAcceptFDRegistrationsBuilder().(*_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataBBMDAcceptFDRegistrationsBuilder creates a BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder
func (b *_BACnetConstructedDataBBMDAcceptFDRegistrations) CreateBACnetConstructedDataBBMDAcceptFDRegistrationsBuilder() BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder {
	if b == nil {
		return NewBACnetConstructedDataBBMDAcceptFDRegistrationsBuilder()
	}
	return &_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder{_BACnetConstructedDataBBMDAcceptFDRegistrations: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_BBMD_ACCEPT_FD_REGISTRATIONS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) GetBbmdAcceptFDRegistrations() BACnetApplicationTagBoolean {
	return m.BbmdAcceptFDRegistrations
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) GetActualValue() BACnetApplicationTagBoolean {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBoolean(m.GetBbmdAcceptFDRegistrations())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataBBMDAcceptFDRegistrations(structType any) BACnetConstructedDataBBMDAcceptFDRegistrations {
	if casted, ok := structType.(BACnetConstructedDataBBMDAcceptFDRegistrations); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataBBMDAcceptFDRegistrations); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) GetTypeName() string {
	return "BACnetConstructedDataBBMDAcceptFDRegistrations"
}

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (bbmdAcceptFDRegistrations)
	lengthInBits += m.BbmdAcceptFDRegistrations.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataBBMDAcceptFDRegistrations BACnetConstructedDataBBMDAcceptFDRegistrations, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataBBMDAcceptFDRegistrations"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataBBMDAcceptFDRegistrations")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	bbmdAcceptFDRegistrations, err := ReadSimpleField[BACnetApplicationTagBoolean](ctx, "bbmdAcceptFDRegistrations", ReadComplex[BACnetApplicationTagBoolean](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBoolean](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bbmdAcceptFDRegistrations' field"))
	}
	m.BbmdAcceptFDRegistrations = bbmdAcceptFDRegistrations

	actualValue, err := ReadVirtualField[BACnetApplicationTagBoolean](ctx, "actualValue", (*BACnetApplicationTagBoolean)(nil), bbmdAcceptFDRegistrations)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataBBMDAcceptFDRegistrations"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataBBMDAcceptFDRegistrations")
	}

	return m, nil
}

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataBBMDAcceptFDRegistrations"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataBBMDAcceptFDRegistrations")
		}

		if err := WriteSimpleField[BACnetApplicationTagBoolean](ctx, "bbmdAcceptFDRegistrations", m.GetBbmdAcceptFDRegistrations(), WriteComplex[BACnetApplicationTagBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'bbmdAcceptFDRegistrations' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataBBMDAcceptFDRegistrations"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataBBMDAcceptFDRegistrations")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) IsBACnetConstructedDataBBMDAcceptFDRegistrations() {
}

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) deepCopy() *_BACnetConstructedDataBBMDAcceptFDRegistrations {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataBBMDAcceptFDRegistrationsCopy := &_BACnetConstructedDataBBMDAcceptFDRegistrations{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagBoolean](m.BbmdAcceptFDRegistrations),
	}
	_BACnetConstructedDataBBMDAcceptFDRegistrationsCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataBBMDAcceptFDRegistrationsCopy
}

func (m *_BACnetConstructedDataBBMDAcceptFDRegistrations) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
