/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ComObjectTable is the corresponding interface of ComObjectTable
type ComObjectTable interface {
	ComObjectTableContract
	ComObjectTableRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsComObjectTable is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsComObjectTable()
	// CreateBuilder creates a ComObjectTableBuilder
	CreateComObjectTableBuilder() ComObjectTableBuilder
}

// ComObjectTableContract provides a set of functions which can be overwritten by a sub struct
type ComObjectTableContract interface {
	// IsComObjectTable is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsComObjectTable()
	// CreateBuilder creates a ComObjectTableBuilder
	CreateComObjectTableBuilder() ComObjectTableBuilder
}

// ComObjectTableRequirements provides a set of functions which need to be implemented by a sub struct
type ComObjectTableRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetFirmwareType returns FirmwareType (discriminator field)
	GetFirmwareType() FirmwareType
}

// _ComObjectTable is the data-structure of this message
type _ComObjectTable struct {
	_SubType interface {
		ComObjectTableContract
		ComObjectTableRequirements
	}
}

var _ ComObjectTableContract = (*_ComObjectTable)(nil)

// NewComObjectTable factory function for _ComObjectTable
func NewComObjectTable() *_ComObjectTable {
	return &_ComObjectTable{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ComObjectTableBuilder is a builder for ComObjectTable
type ComObjectTableBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ComObjectTableBuilder
	// AsComObjectTableRealisationType1 converts this build to a subType of ComObjectTable. It is always possible to return to current builder using Done()
	AsComObjectTableRealisationType1() ComObjectTableRealisationType1Builder
	// AsComObjectTableRealisationType2 converts this build to a subType of ComObjectTable. It is always possible to return to current builder using Done()
	AsComObjectTableRealisationType2() ComObjectTableRealisationType2Builder
	// AsComObjectTableRealisationType6 converts this build to a subType of ComObjectTable. It is always possible to return to current builder using Done()
	AsComObjectTableRealisationType6() ComObjectTableRealisationType6Builder
	// Build builds the ComObjectTable or returns an error if something is wrong
	PartialBuild() (ComObjectTableContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() ComObjectTableContract
	// Build builds the ComObjectTable or returns an error if something is wrong
	Build() (ComObjectTable, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ComObjectTable
}

// NewComObjectTableBuilder() creates a ComObjectTableBuilder
func NewComObjectTableBuilder() ComObjectTableBuilder {
	return &_ComObjectTableBuilder{_ComObjectTable: new(_ComObjectTable)}
}

type _ComObjectTableChildBuilder interface {
	utils.Copyable
	setParent(ComObjectTableContract)
	buildForComObjectTable() (ComObjectTable, error)
}

type _ComObjectTableBuilder struct {
	*_ComObjectTable

	childBuilder _ComObjectTableChildBuilder

	collectedErr []error
}

var _ (ComObjectTableBuilder) = (*_ComObjectTableBuilder)(nil)

func (b *_ComObjectTableBuilder) WithMandatoryFields() ComObjectTableBuilder {
	return b
}

func (b *_ComObjectTableBuilder) PartialBuild() (ComObjectTableContract, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ComObjectTable.deepCopy(), nil
}

func (b *_ComObjectTableBuilder) PartialMustBuild() ComObjectTableContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ComObjectTableBuilder) AsComObjectTableRealisationType1() ComObjectTableRealisationType1Builder {
	if cb, ok := b.childBuilder.(ComObjectTableRealisationType1Builder); ok {
		return cb
	}
	cb := NewComObjectTableRealisationType1Builder().(*_ComObjectTableRealisationType1Builder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ComObjectTableBuilder) AsComObjectTableRealisationType2() ComObjectTableRealisationType2Builder {
	if cb, ok := b.childBuilder.(ComObjectTableRealisationType2Builder); ok {
		return cb
	}
	cb := NewComObjectTableRealisationType2Builder().(*_ComObjectTableRealisationType2Builder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ComObjectTableBuilder) AsComObjectTableRealisationType6() ComObjectTableRealisationType6Builder {
	if cb, ok := b.childBuilder.(ComObjectTableRealisationType6Builder); ok {
		return cb
	}
	cb := NewComObjectTableRealisationType6Builder().(*_ComObjectTableRealisationType6Builder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ComObjectTableBuilder) Build() (ComObjectTable, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForComObjectTable()
}

func (b *_ComObjectTableBuilder) MustBuild() ComObjectTable {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ComObjectTableBuilder) DeepCopy() any {
	_copy := b.CreateComObjectTableBuilder().(*_ComObjectTableBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_ComObjectTableChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateComObjectTableBuilder creates a ComObjectTableBuilder
func (b *_ComObjectTable) CreateComObjectTableBuilder() ComObjectTableBuilder {
	if b == nil {
		return NewComObjectTableBuilder()
	}
	return &_ComObjectTableBuilder{_ComObjectTable: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastComObjectTable(structType any) ComObjectTable {
	if casted, ok := structType.(ComObjectTable); ok {
		return casted
	}
	if casted, ok := structType.(*ComObjectTable); ok {
		return *casted
	}
	return nil
}

func (m *_ComObjectTable) GetTypeName() string {
	return "ComObjectTable"
}

func (m *_ComObjectTable) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_ComObjectTable) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_ComObjectTable) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func ComObjectTableParse[T ComObjectTable](ctx context.Context, theBytes []byte, firmwareType FirmwareType) (T, error) {
	return ComObjectTableParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), firmwareType)
}

func ComObjectTableParseWithBufferProducer[T ComObjectTable](firmwareType FirmwareType) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := ComObjectTableParseWithBuffer[T](ctx, readBuffer, firmwareType)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func ComObjectTableParseWithBuffer[T ComObjectTable](ctx context.Context, readBuffer utils.ReadBuffer, firmwareType FirmwareType) (T, error) {
	v, err := (&_ComObjectTable{}).parse(ctx, readBuffer, firmwareType)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_ComObjectTable) parse(ctx context.Context, readBuffer utils.ReadBuffer, firmwareType FirmwareType) (__comObjectTable ComObjectTable, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ComObjectTable"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ComObjectTable")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child ComObjectTable
	switch {
	case firmwareType == FirmwareType_SYSTEM_1: // ComObjectTableRealisationType1
		if _child, err = new(_ComObjectTableRealisationType1).parse(ctx, readBuffer, m, firmwareType); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ComObjectTableRealisationType1 for type-switch of ComObjectTable")
		}
	case firmwareType == FirmwareType_SYSTEM_2: // ComObjectTableRealisationType2
		if _child, err = new(_ComObjectTableRealisationType2).parse(ctx, readBuffer, m, firmwareType); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ComObjectTableRealisationType2 for type-switch of ComObjectTable")
		}
	case firmwareType == FirmwareType_SYSTEM_300: // ComObjectTableRealisationType6
		if _child, err = new(_ComObjectTableRealisationType6).parse(ctx, readBuffer, m, firmwareType); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ComObjectTableRealisationType6 for type-switch of ComObjectTable")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [firmwareType=%v]", firmwareType)
	}

	if closeErr := readBuffer.CloseContext("ComObjectTable"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ComObjectTable")
	}

	return _child, nil
}

func (pm *_ComObjectTable) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child ComObjectTable, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ComObjectTable"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ComObjectTable")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("ComObjectTable"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ComObjectTable")
	}
	return nil
}

func (m *_ComObjectTable) IsComObjectTable() {}

func (m *_ComObjectTable) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ComObjectTable) deepCopy() *_ComObjectTable {
	if m == nil {
		return nil
	}
	_ComObjectTableCopy := &_ComObjectTable{
		nil, // will be set by child
	}
	return _ComObjectTableCopy
}
