/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DatagramConnectionTransport2DataType extends ExtensionObjectDefinition
    implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 23614;
  }

  // Properties.
  protected final ExtensionObject discoveryAddress;
  protected final long discoveryAnnounceRate;
  protected final long discoveryMaxMessageSize;
  protected final PascalString qosCategory;
  protected final List<ExtensionObject> datagramQos;

  public DatagramConnectionTransport2DataType(
      ExtensionObject discoveryAddress,
      long discoveryAnnounceRate,
      long discoveryMaxMessageSize,
      PascalString qosCategory,
      List<ExtensionObject> datagramQos) {
    super();
    this.discoveryAddress = discoveryAddress;
    this.discoveryAnnounceRate = discoveryAnnounceRate;
    this.discoveryMaxMessageSize = discoveryMaxMessageSize;
    this.qosCategory = qosCategory;
    this.datagramQos = datagramQos;
  }

  public ExtensionObject getDiscoveryAddress() {
    return discoveryAddress;
  }

  public long getDiscoveryAnnounceRate() {
    return discoveryAnnounceRate;
  }

  public long getDiscoveryMaxMessageSize() {
    return discoveryMaxMessageSize;
  }

  public PascalString getQosCategory() {
    return qosCategory;
  }

  public List<ExtensionObject> getDatagramQos() {
    return datagramQos;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("DatagramConnectionTransport2DataType");

    // Simple Field (discoveryAddress)
    writeSimpleField("discoveryAddress", discoveryAddress, writeComplex(writeBuffer));

    // Simple Field (discoveryAnnounceRate)
    writeSimpleField(
        "discoveryAnnounceRate", discoveryAnnounceRate, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (discoveryMaxMessageSize)
    writeSimpleField(
        "discoveryMaxMessageSize", discoveryMaxMessageSize, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (qosCategory)
    writeSimpleField("qosCategory", qosCategory, writeComplex(writeBuffer));

    // Implicit Field (noOfDatagramQos) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfDatagramQos = (int) ((((getDatagramQos()) == (null)) ? -(1) : COUNT(getDatagramQos())));
    writeImplicitField("noOfDatagramQos", noOfDatagramQos, writeSignedInt(writeBuffer, 32));

    // Array Field (datagramQos)
    writeComplexTypeArrayField("datagramQos", datagramQos, writeBuffer);

    writeBuffer.popContext("DatagramConnectionTransport2DataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    DatagramConnectionTransport2DataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (discoveryAddress)
    lengthInBits += discoveryAddress.getLengthInBits();

    // Simple field (discoveryAnnounceRate)
    lengthInBits += 32;

    // Simple field (discoveryMaxMessageSize)
    lengthInBits += 32;

    // Simple field (qosCategory)
    lengthInBits += qosCategory.getLengthInBits();

    // Implicit Field (noOfDatagramQos)
    lengthInBits += 32;

    // Array field
    if (datagramQos != null) {
      int i = 0;
      for (ExtensionObject element : datagramQos) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= datagramQos.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("DatagramConnectionTransport2DataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ExtensionObject discoveryAddress =
        readSimpleField(
            "discoveryAddress",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    long discoveryAnnounceRate =
        readSimpleField("discoveryAnnounceRate", readUnsignedLong(readBuffer, 32));

    long discoveryMaxMessageSize =
        readSimpleField("discoveryMaxMessageSize", readUnsignedLong(readBuffer, 32));

    PascalString qosCategory =
        readSimpleField(
            "qosCategory", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfDatagramQos = readImplicitField("noOfDatagramQos", readSignedInt(readBuffer, 32));

    List<ExtensionObject> datagramQos =
        readCountArrayField(
            "datagramQos",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer),
            noOfDatagramQos);

    readBuffer.closeContext("DatagramConnectionTransport2DataType");
    // Create the instance
    return new DatagramConnectionTransport2DataTypeBuilderImpl(
        discoveryAddress, discoveryAnnounceRate, discoveryMaxMessageSize, qosCategory, datagramQos);
  }

  public static class DatagramConnectionTransport2DataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObject discoveryAddress;
    private final long discoveryAnnounceRate;
    private final long discoveryMaxMessageSize;
    private final PascalString qosCategory;
    private final List<ExtensionObject> datagramQos;

    public DatagramConnectionTransport2DataTypeBuilderImpl(
        ExtensionObject discoveryAddress,
        long discoveryAnnounceRate,
        long discoveryMaxMessageSize,
        PascalString qosCategory,
        List<ExtensionObject> datagramQos) {
      this.discoveryAddress = discoveryAddress;
      this.discoveryAnnounceRate = discoveryAnnounceRate;
      this.discoveryMaxMessageSize = discoveryMaxMessageSize;
      this.qosCategory = qosCategory;
      this.datagramQos = datagramQos;
    }

    public DatagramConnectionTransport2DataType build() {
      DatagramConnectionTransport2DataType datagramConnectionTransport2DataType =
          new DatagramConnectionTransport2DataType(
              discoveryAddress,
              discoveryAnnounceRate,
              discoveryMaxMessageSize,
              qosCategory,
              datagramQos);
      return datagramConnectionTransport2DataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DatagramConnectionTransport2DataType)) {
      return false;
    }
    DatagramConnectionTransport2DataType that = (DatagramConnectionTransport2DataType) o;
    return (getDiscoveryAddress() == that.getDiscoveryAddress())
        && (getDiscoveryAnnounceRate() == that.getDiscoveryAnnounceRate())
        && (getDiscoveryMaxMessageSize() == that.getDiscoveryMaxMessageSize())
        && (getQosCategory() == that.getQosCategory())
        && (getDatagramQos() == that.getDatagramQos())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getDiscoveryAddress(),
        getDiscoveryAnnounceRate(),
        getDiscoveryMaxMessageSize(),
        getQosCategory(),
        getDatagramQos());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
