/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.NotReplicatedException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.ReadIndexException;
import org.apache.ratis.protocol.exceptions.ReconfigurationTimeoutException;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.CommitInfoCache;
import org.apache.ratis.server.impl.FollowerInfoImpl;
import org.apache.ratis.server.impl.LeaderLease;
import org.apache.ratis.server.impl.MessageStreamRequests;
import org.apache.ratis.server.impl.PeerConfiguration;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.server.impl.PendingRequests;
import org.apache.ratis.server.impl.PendingStepDown;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ReadIndexHeartbeats;
import org.apache.ratis.server.impl.ServerImplUtils;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.impl.TransferLeadership;
import org.apache.ratis.server.impl.WatchRequests;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.server.metrics.LogAppenderMetrics;
import org.apache.ratis.server.metrics.RaftServerMetricsImpl;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogEntryHeader;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;

class LeaderStateImpl
implements LeaderState {
    public static final String APPEND_PLACEHOLDER = JavaUtils.getClassSimpleName(LeaderState.class) + ".placeholder";
    private final StateUpdateEvent updateCommitEvent = new StateUpdateEvent(StateUpdateEvent.Type.UPDATE_COMMIT, this::updateCommit);
    private final StateUpdateEvent checkStagingEvent = new StateUpdateEvent(StateUpdateEvent.Type.CHECK_STAGING, this::checkStaging);
    private final String name;
    private final RaftServerImpl server;
    private final RaftLog raftLog;
    private final long currentTerm;
    private volatile ConfigurationStagingState stagingState;
    private final FollowerInfoMap followerInfoMap = new FollowerInfoMap();
    private final SenderList senders;
    private final EventQueue eventQueue;
    private final EventProcessor processor;
    private final PendingRequests pendingRequests;
    private final WatchRequests watchRequests;
    private final MessageStreamRequests messageStreamRequests;
    private final MemoizedSupplier<StartupLogEntry> startupLogEntry = MemoizedSupplier.valueOf(() -> new StartupLogEntry());
    private final AtomicBoolean isStopped = new AtomicBoolean();
    private final boolean logMetadataEnabled;
    private final int stagingCatchupGap;
    private final TimeDuration stagingTimeout;
    private final RaftServerMetricsImpl raftServerMetrics;
    private final LogAppenderMetrics logAppenderMetrics;
    private final long followerMaxGapThreshold;
    private final PendingStepDown pendingStepDown;
    private final ReadIndexHeartbeats readIndexHeartbeats;
    private final LeaderLease lease;

    static boolean isSameSize(List<FollowerInfo> infos, PeerConfiguration conf) {
        return conf == null ? infos == null : conf.size() == infos.size();
    }

    static boolean isSameConf(CurrentOldFollowerInfos cached, RaftConfigurationImpl conf) {
        return cached != null && cached.getConf() == conf;
    }

    LeaderStateImpl(RaftServerImpl server) {
        this.name = ServerStringUtils.generateUnifiedName(server.getMemberId(), this.getClass());
        this.server = server;
        RaftProperties properties = server.getRaftServer().getProperties();
        this.stagingCatchupGap = RaftServerConfigKeys.stagingCatchupGap((RaftProperties)properties);
        this.stagingTimeout = RaftServerConfigKeys.stagingTimeout((RaftProperties)properties);
        ServerState state = server.getState();
        this.raftLog = state.getLog();
        this.currentTerm = state.getCurrentTerm();
        this.eventQueue = new EventQueue();
        this.processor = new EventProcessor(this.name, server);
        this.raftServerMetrics = server.getRaftServerMetrics();
        this.logAppenderMetrics = new LogAppenderMetrics(server.getMemberId());
        this.pendingRequests = new PendingRequests(server.getMemberId(), properties, this.raftServerMetrics);
        this.watchRequests = new WatchRequests(server.getMemberId(), properties, this.raftServerMetrics);
        this.messageStreamRequests = new MessageStreamRequests(server.getMemberId());
        this.pendingStepDown = new PendingStepDown(this);
        this.readIndexHeartbeats = new ReadIndexHeartbeats();
        this.lease = new LeaderLease(properties);
        this.logMetadataEnabled = RaftServerConfigKeys.Log.logMetadataEnabled((RaftProperties)properties);
        long maxPendingRequests = RaftServerConfigKeys.Write.elementLimit((RaftProperties)properties);
        double followerGapRatioMax = RaftServerConfigKeys.Write.followerGapRatioMax((RaftProperties)properties);
        if (followerGapRatioMax == -1.0) {
            this.followerMaxGapThreshold = -1L;
        } else {
            if (followerGapRatioMax > 1.0 || followerGapRatioMax <= 0.0) {
                throw new IllegalArgumentException("raft.server.write.follower.gap.ratio.maxs value must between [1, 0) to enable the feature");
            }
            this.followerMaxGapThreshold = (long)(followerGapRatioMax * (double)maxPendingRequests);
        }
        RaftConfigurationImpl conf = state.getRaftConf();
        Collection<RaftPeer> others = conf.getOtherPeers(server.getId());
        long nextIndex = this.raftLog.getNextIndex();
        this.senders = new SenderList();
        this.addSenders(others, nextIndex, true);
        Collection listeners = conf.getAllPeers(RaftProtos.RaftPeerRole.LISTENER);
        if (!listeners.isEmpty()) {
            this.addSenders(listeners, nextIndex, true);
        }
    }

    void start() {
        CodeInjectionForTesting.execute((String)APPEND_PLACEHOLDER, (Object)this.server.getId().toString(), null, (Object[])new Object[0]);
        this.startupLogEntry.get();
        this.processor.start();
        this.senders.forEach(LogAppender::start);
    }

    boolean isReady() {
        return this.startupLogEntry.isInitialized() && ((StartupLogEntry)this.startupLogEntry.get()).isApplied();
    }

    void checkReady(RaftProtos.LogEntryProto entry) {
        if (entry.getTerm() == this.server.getState().getCurrentTerm() && ((StartupLogEntry)this.startupLogEntry.get()).checkStartIndex(entry)) {
            this.server.getStateMachine().leaderEvent().notifyLeaderReady();
        }
    }

    CompletableFuture<Void> stop() {
        if (!this.isStopped.compareAndSet(false, true)) {
            RaftServer.Division.LOG.info("{} is already stopped", (Object)this);
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> f = this.senders.stopAll();
        NotLeaderException nle = this.server.generateNotLeaderException();
        Collection<RaftProtos.CommitInfoProto> commitInfos = this.server.getCommitInfos();
        try {
            Collection<TransactionContext> transactions = this.pendingRequests.sendNotLeaderResponses(nle, commitInfos);
            this.server.getStateMachine().leaderEvent().notifyNotLeader(transactions);
            this.watchRequests.failWatches((Exception)nle);
        }
        catch (IOException e) {
            RaftServer.Division.LOG.warn("{}: Caught exception in sendNotLeaderResponses", (Object)this, (Object)e);
        }
        this.messageStreamRequests.clear();
        this.readIndexHeartbeats.failListeners((Exception)nle);
        this.lease.getAndSetEnabled(false);
        ((StartupLogEntry)this.startupLogEntry.get()).getAppliedIndexFuture().completeExceptionally((Throwable)new ReadIndexException("failed to obtain read index since: ", (Throwable)nle));
        this.server.getServerRpc().notifyNotLeader(this.server.getMemberId().getGroupId());
        this.logAppenderMetrics.unregister();
        this.raftServerMetrics.unregister();
        this.pendingRequests.close();
        this.watchRequests.close();
        return f;
    }

    void notifySenders() {
        this.senders.forEach(LogAppender::notifyLogAppender);
    }

    boolean inStagingState() {
        return this.stagingState != null;
    }

    long getCurrentTerm() {
        Preconditions.assertSame((long)this.currentTerm, (long)this.server.getState().getCurrentTerm(), (String)"currentTerm");
        return this.currentTerm;
    }

    public boolean onFollowerTerm(FollowerInfo follower, long followerTerm) {
        if (LeaderStateImpl.isCaughtUp(follower) && followerTerm > this.getCurrentTerm()) {
            this.submitStepDownEvent(followerTerm, LeaderState.StepDownReason.HIGHER_TERM);
            return true;
        }
        return false;
    }

    PendingRequest startSetConfiguration(SetConfigurationRequest request, List<RaftPeer> peersInNewConf) {
        Collection<Object> allNew;
        RaftServer.Division.LOG.info("{}: startSetConfiguration {}", (Object)this, (Object)request);
        Preconditions.assertTrue((boolean)this.isRunning(), () -> this + " is not running.");
        Preconditions.assertTrue((!this.inStagingState() ? 1 : 0) != 0, () -> this + " is already in staging state " + this.stagingState);
        List listenersInNewConf = request.getArguments().getPeersInNewConf(RaftProtos.RaftPeerRole.LISTENER);
        Collection<RaftPeer> peersToBootStrap = this.server.getRaftConf().filterNotContainedInConf(peersInNewConf);
        Collection<RaftPeer> listenersToBootStrap = this.server.getRaftConf().filterNotContainedInConf(listenersInNewConf);
        PendingRequest pending = this.pendingRequests.addConfRequest(request);
        ConfigurationStagingState configurationStagingState = new ConfigurationStagingState(peersToBootStrap, listenersToBootStrap, new PeerConfiguration(peersInNewConf, listenersInNewConf));
        Collection<Object> newPeers = configurationStagingState.getNewPeers();
        Collection<RaftPeer> newListeners = configurationStagingState.getNewListeners();
        Collection<Object> collection = newListeners.isEmpty() ? newPeers : (allNew = newPeers.isEmpty() ? newListeners : (Collection<Object>)Stream.concat(newPeers.stream(), newListeners.stream()).collect(Collectors.toList()));
        if (allNew.isEmpty()) {
            this.applyOldNewConf(configurationStagingState);
        } else {
            Collection<LogAppender> newAppenders = this.addSenders(allNew);
            this.stagingState = configurationStagingState;
            newAppenders.forEach(LogAppender::start);
        }
        return pending;
    }

    PendingRequests.Permit tryAcquirePendingRequest(Message message) {
        return this.pendingRequests.tryAcquire(message);
    }

    PendingRequest addPendingRequest(PendingRequests.Permit permit, RaftClientRequest request, TransactionContext entry) {
        if (RaftServer.Division.LOG.isDebugEnabled()) {
            RaftServer.Division.LOG.debug("{}: addPendingRequest at {}, entry={}", new Object[]{this, request, LogProtoUtils.toLogEntryString(entry.getLogEntry())});
        }
        return this.pendingRequests.add(permit, request, entry);
    }

    CompletableFuture<RaftClientReply> streamAsync(RaftClientRequest request) {
        return ((CompletableFuture)this.messageStreamRequests.streamAsync(request).thenApply(dummy -> this.server.newSuccessReply(request))).exceptionally(e -> this.exception2RaftClientReply(request, (Throwable)e));
    }

    CompletableFuture<RaftClientRequest> streamEndOfRequestAsync(RaftClientRequest request) {
        return this.messageStreamRequests.streamEndOfRequestAsync(request).thenApply(bytes -> RaftClientRequest.toWriteRequest((RaftClientRequest)request, (Message)Message.valueOf((ByteString)bytes)));
    }

    CompletableFuture<RaftClientReply> addWatchRequest(RaftClientRequest request) {
        RaftServer.Division.LOG.debug("{}: addWatchRequest {}", (Object)this, (Object)request);
        return ((CompletableFuture)this.watchRequests.add(request).thenApply(logIndex -> this.server.newSuccessReply(request, (long)logIndex))).exceptionally(e -> this.exception2RaftClientReply(request, (Throwable)e));
    }

    private RaftClientReply exception2RaftClientReply(RaftClientRequest request, Throwable e) {
        if ((e = JavaUtils.unwrapCompletionException((Throwable)e)) instanceof NotReplicatedException) {
            NotReplicatedException nre = (NotReplicatedException)e;
            return this.server.newReplyBuilder(request).setException((RaftException)nre).setLogIndex(nre.getLogIndex()).build();
        }
        if (e instanceof NotLeaderException) {
            return this.server.newExceptionReply(request, (RaftException)((NotLeaderException)e));
        }
        if (e instanceof LeaderNotReadyException) {
            return this.server.newExceptionReply(request, (RaftException)((LeaderNotReadyException)e));
        }
        throw new CompletionException(e);
    }

    public void onFollowerCommitIndex(FollowerInfo follower, long commitIndex) {
        if (follower.updateCommitIndex(commitIndex)) {
            this.commitIndexChanged();
        }
    }

    private void commitIndexChanged() {
        this.getMajorityMin(FollowerInfo::getCommitIndex, () -> ((RaftLog)this.raftLog).getLastCommittedIndex()).ifPresent(m -> {
            this.watchRequests.update(RaftProtos.ReplicationLevel.ALL_COMMITTED, ((MinMajorityMax)m).min);
            this.watchRequests.update(RaftProtos.ReplicationLevel.MAJORITY_COMMITTED, ((MinMajorityMax)m).majority);
            this.watchRequests.update(RaftProtos.ReplicationLevel.MAJORITY, ((MinMajorityMax)m).max);
        });
        this.notifySenders();
    }

    private void applyOldNewConf(ConfigurationStagingState stage) {
        ServerState state = this.server.getState();
        RaftConfigurationImpl current = state.getRaftConf();
        long nextIndex = state.getLog().getNextIndex();
        RaftConfigurationImpl oldNewConf = stage.generateOldNewConf(current, nextIndex);
        this.appendConfiguration(oldNewConf);
        this.notifySenders();
    }

    private long appendConfiguration(RaftConfigurationImpl conf) {
        long logIndex = this.raftLog.append(this.getCurrentTerm(), (RaftConfiguration)conf);
        Preconditions.assertSame((long)conf.getLogEntryIndex(), (long)logIndex, (String)"confLogIndex");
        this.server.getState().setRaftConf(conf);
        return logIndex;
    }

    void updateFollowerCommitInfos(CommitInfoCache cache, List<RaftProtos.CommitInfoProto> protos) {
        for (LogAppender sender : this.senders) {
            FollowerInfo info = sender.getFollower();
            protos.add(cache.update(info.getPeer(), info.getCommitIndex()));
        }
    }

    public RaftProtos.AppendEntriesRequestProto newAppendEntriesRequestProto(FollowerInfo follower, List<RaftProtos.LogEntryProto> entries, TermIndex previous, long callId) {
        boolean initializing = !LeaderStateImpl.isCaughtUp(follower);
        RaftPeerId targetId = follower.getId();
        return ServerProtoUtils.toAppendEntriesRequestProto(this.server.getMemberId(), targetId, this.getCurrentTerm(), entries, ServerImplUtils.effectiveCommitIndex(this.raftLog.getLastCommittedIndex(), previous, entries.size()), initializing, previous, this.server.getCommitInfos(), callId);
    }

    private void addAndStartSenders(Collection<RaftPeer> newPeers) {
        this.addSenders(newPeers).forEach(LogAppender::start);
    }

    private Collection<LogAppender> addSenders(Collection<RaftPeer> newPeers) {
        return !newPeers.isEmpty() ? this.addSenders(newPeers, 0L, false) : Collections.emptyList();
    }

    private RaftPeer getPeer(RaftPeerId id) {
        return this.server.getRaftConf().getPeer(id, RaftProtos.RaftPeerRole.FOLLOWER, RaftProtos.RaftPeerRole.LISTENER);
    }

    private LogAppender newLogAppender(FollowerInfo f) {
        return this.server.getRaftServer().getFactory().newLogAppender((RaftServer.Division)this.server, (LeaderState)this, f);
    }

    private Collection<LogAppender> addSenders(Collection<RaftPeer> newPeers, long nextIndex, boolean caughtUp) {
        Timestamp t = Timestamp.currentTime().addTimeMs((long)(-this.server.getMaxTimeoutMs()));
        List<LogAppender> newAppenders = newPeers.stream().map(peer -> {
            FollowerInfoImpl f = new FollowerInfoImpl(this.server.getMemberId(), (RaftPeer)peer, this::getPeer, t, nextIndex, caughtUp);
            this.followerInfoMap.put(peer.getId(), f);
            this.raftServerMetrics.addFollower(peer.getId());
            this.logAppenderMetrics.addFollowerGauges(peer.getId(), () -> ((FollowerInfo)f).getNextIndex(), () -> ((FollowerInfo)f).getMatchIndex(), () -> ((FollowerInfo)f).getLastRpcTime());
            return this.newLogAppender(f);
        }).collect(Collectors.toList());
        this.senders.addAll(newAppenders);
        return newAppenders;
    }

    private void stopAndRemoveSenders(Predicate<LogAppender> predicate) {
        this.stopAndRemoveSenders(this.getLogAppenders().filter(predicate).collect(Collectors.toList()));
    }

    private void stopAndRemoveSenders(Collection<LogAppender> toStop) {
        toStop.forEach(LogAppender::stopAsync);
        this.senders.removeAll(toStop);
    }

    boolean isRunning() {
        if (this.isStopped.get()) {
            return false;
        }
        LeaderStateImpl current = this.server.getRole().getLeaderState().orElse(null);
        return this == current;
    }

    public void restart(LogAppender sender) {
        if (!this.isRunning()) {
            RaftServer.Division.LOG.warn("Failed to restart {}: {} is not running", (Object)sender, (Object)this);
            return;
        }
        FollowerInfo info = sender.getFollower();
        RaftServer.Division.LOG.info("{}: Restarting {} for {}", new Object[]{this, JavaUtils.getClassSimpleName(sender.getClass()), info.getName()});
        this.stopAndRemoveSenders(Collections.singleton(sender));
        Optional.ofNullable(this.getPeer(info.getId())).ifPresent(peer -> this.addAndStartSenders(Collections.singleton(peer)));
    }

    private void updateSenders(RaftConfigurationImpl conf) {
        Preconditions.assertTrue((conf.isStable() && !this.inStagingState() ? 1 : 0) != 0);
        this.stopAndRemoveSenders((LogAppender s) -> !conf.containsInConf(s.getFollowerId(), RaftProtos.RaftPeerRole.FOLLOWER, RaftProtos.RaftPeerRole.LISTENER));
    }

    void submitStepDownEvent(LeaderState.StepDownReason reason) {
        this.submitStepDownEvent(this.currentTerm, reason);
    }

    void submitStepDownEvent(long term, LeaderState.StepDownReason reason) {
        this.eventQueue.submit(new StateUpdateEvent(StateUpdateEvent.Type.STEP_DOWN, () -> this.stepDown(term, reason)));
    }

    private void stepDown(long term, LeaderState.StepDownReason reason) {
        block2: {
            try {
                this.lease.getAndSetEnabled(false);
                this.server.changeToFollowerAndPersistMetadata(term, false, reason).get(5L, TimeUnit.SECONDS);
                this.pendingStepDown.complete(this.server::newSuccessReply);
            }
            catch (Exception e) {
                this.pendingStepDown.completeExceptionally(e);
                String s = this + ": Failed to step down for term " + term;
                RaftServer.Division.LOG.warn(s, (Throwable)e);
                if (this.isStopped.get()) break block2;
                throw new IllegalStateException(s + " and running == true", e);
            }
        }
    }

    CompletableFuture<RaftClientReply> submitStepDownRequestAsync(TransferLeadershipRequest request) {
        return this.pendingStepDown.submitAsync(request);
    }

    private static LogAppender chooseUpToDateFollower(List<LogAppender> followers, TermIndex leaderLastEntry) {
        for (LogAppender f : followers) {
            if (TransferLeadership.isFollowerUpToDate(f.getFollower(), leaderLastEntry) != TransferLeadership.Result.SUCCESS) continue;
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare() {
        RaftServerImpl raftServerImpl = this.server;
        synchronized (raftServerImpl) {
            ServerState state;
            if (this.isRunning() && (state = this.server.getState()).getRaftConf().isTransitional() && state.isConfCommitted()) {
                this.replicateNewConf();
            }
        }
    }

    private BootStrapProgress checkProgress(FollowerInfo follower, long committed) {
        Preconditions.assertTrue((!LeaderStateImpl.isCaughtUp(follower) ? 1 : 0) != 0);
        Timestamp progressTime = Timestamp.currentTime().addTimeMs((long)(-this.server.getMaxTimeoutMs()));
        Timestamp timeoutTime = Timestamp.currentTime().addTimeMs(-this.stagingTimeout.toLong(TimeUnit.MILLISECONDS));
        if (follower.getLastRpcResponseTime().compareTo(timeoutTime) < 0) {
            RaftServer.Division.LOG.debug("{} detects a follower {} timeout ({}ms) for bootstrapping", new Object[]{this, follower, follower.getLastRpcResponseTime().elapsedTimeMs()});
            return BootStrapProgress.NOPROGRESS;
        }
        if (follower.getMatchIndex() + (long)this.stagingCatchupGap > committed && follower.getMatchIndex() >= this.server.getRaftConf().getLogEntryIndex() && follower.getLastRpcResponseTime().compareTo(progressTime) > 0 && follower.hasAttemptedToInstallSnapshot()) {
            return BootStrapProgress.CAUGHTUP;
        }
        return BootStrapProgress.PROGRESSING;
    }

    public void onFollowerSuccessAppendEntries(FollowerInfo follower) {
        if (LeaderStateImpl.isCaughtUp(follower)) {
            this.submitUpdateCommitEvent();
        } else {
            this.eventQueue.submit(this.checkStagingEvent);
        }
        this.server.getTransferLeadership().onFollowerAppendEntriesReply(follower);
    }

    public boolean isFollowerBootstrapping(FollowerInfo follower) {
        return !LeaderStateImpl.isCaughtUp(follower);
    }

    private void checkStaging() {
        if (!this.inStagingState()) {
            this.updateCommitEvent.execute();
        } else {
            long commitIndex = this.server.getState().getLog().getLastCommittedIndex();
            List laggingFollowers = this.getLogAppenders().map(LogAppender::getFollower).filter(follower -> !LeaderStateImpl.isCaughtUp(follower)).map(FollowerInfoImpl.class::cast).collect(Collectors.toList());
            EnumSet reports = laggingFollowers.stream().map(follower -> this.checkProgress((FollowerInfo)follower, commitIndex)).collect(Collectors.toCollection(() -> EnumSet.noneOf(BootStrapProgress.class)));
            if (reports.contains((Object)BootStrapProgress.NOPROGRESS)) {
                this.stagingState.fail(BootStrapProgress.NOPROGRESS);
            } else if (!reports.contains((Object)BootStrapProgress.PROGRESSING)) {
                this.applyOldNewConf(this.stagingState);
                this.stagingState = null;
                laggingFollowers.stream().filter(f -> this.server.getRaftConf().containsInConf(f.getId(), new RaftProtos.RaftPeerRole[0])).forEach(FollowerInfoImpl::catchUp);
            }
        }
    }

    boolean isBootStrappingPeer(RaftPeerId peerId) {
        Optional<LogAppender> info = this.getLogAppender(peerId);
        if (info.isPresent()) {
            return !LeaderStateImpl.isCaughtUp(info.get().getFollower());
        }
        ConfigurationStagingState staging = this.stagingState;
        return staging != null && staging.contains(peerId);
    }

    void submitUpdateCommitEvent() {
        this.eventQueue.submit(this.updateCommitEvent);
    }

    private void updateCommit() {
        this.getMajorityMin(FollowerInfo::getMatchIndex, () -> ((RaftLog)this.raftLog).getFlushIndex(), this.followerMaxGapThreshold).ifPresent(m -> this.updateCommit(((MinMajorityMax)m).majority, ((MinMajorityMax)m).min));
    }

    private Optional<MinMajorityMax> getMajorityMin(ToLongFunction<FollowerInfo> followerIndex, LongSupplier logIndex) {
        return this.getMajorityMin(followerIndex, logIndex, -1L);
    }

    private Optional<MinMajorityMax> getMajorityMin(ToLongFunction<FollowerInfo> followerIndex, LongSupplier logIndex, long gapThreshold) {
        RaftPeerId selfId = this.server.getId();
        RaftConfigurationImpl conf = this.server.getRaftConf();
        CurrentOldFollowerInfos infos = this.followerInfoMap.getFollowerInfos(conf);
        List<FollowerInfo> followers = infos.getCurrent();
        boolean includeSelf = conf.containsInConf(selfId, new RaftProtos.RaftPeerRole[0]);
        if (followers.isEmpty() && !includeSelf) {
            return Optional.empty();
        }
        long[] indicesInNewConf = this.getSorted(followers, includeSelf, followerIndex, logIndex);
        MinMajorityMax newConf = MinMajorityMax.valueOf(indicesInNewConf, gapThreshold);
        if (!conf.isTransitional()) {
            return Optional.of(newConf);
        }
        List<FollowerInfo> oldFollowers = infos.getOld();
        boolean includeSelfInOldConf = conf.containsInOldConf(selfId);
        if (oldFollowers.isEmpty() && !includeSelfInOldConf) {
            return Optional.empty();
        }
        long[] indicesInOldConf = this.getSorted(oldFollowers, includeSelfInOldConf, followerIndex, logIndex);
        MinMajorityMax oldConf = MinMajorityMax.valueOf(indicesInOldConf, gapThreshold);
        return Optional.of(newConf.combine(oldConf));
    }

    private boolean hasMajority(Predicate<RaftPeerId> isAcked) {
        RaftPeerId selfId = this.server.getId();
        return this.server.getRaftConf().hasMajority(isAcked, selfId);
    }

    private void updateCommit(LogEntryHeader[] entriesToCommit) {
        long newCommitIndex = this.raftLog.getLastCommittedIndex();
        long lastCommitIndex = -1L;
        boolean hasConfiguration = false;
        for (LogEntryHeader entry : entriesToCommit) {
            if (entry.getIndex() > newCommitIndex) break;
            hasConfiguration |= entry.getLogEntryBodyCase() == RaftProtos.LogEntryProto.LogEntryBodyCase.CONFIGURATIONENTRY;
            this.raftLog.getRaftLogMetrics().onLogEntryCommitted(entry);
            if (entry.getLogEntryBodyCase() == RaftProtos.LogEntryProto.LogEntryBodyCase.METADATAENTRY) continue;
            lastCommitIndex = entry.getIndex();
        }
        if (this.logMetadataEnabled && lastCommitIndex != -1L) {
            this.logMetadata(lastCommitIndex);
        }
        this.commitIndexChanged();
        if (hasConfiguration) {
            this.checkAndUpdateConfiguration();
        }
    }

    private void updateCommit(long majority, long min) {
        long oldLastCommitted = this.raftLog.getLastCommittedIndex();
        if (majority > oldLastCommitted) {
            LogEntryHeader[] entriesToCommit = this.raftLog.getEntries(oldLastCommitted + 1L, majority + 1L);
            if (this.server.getState().updateCommitIndex(majority, this.currentTerm, true)) {
                this.updateCommit(entriesToCommit);
            }
        }
        this.watchRequests.update(RaftProtos.ReplicationLevel.ALL, min);
    }

    private void logMetadata(long commitIndex) {
        if (this.raftLog.appendMetadata(this.currentTerm, commitIndex) != -1L) {
            this.notifySenders();
        }
    }

    private void checkAndUpdateConfiguration() {
        RaftConfigurationImpl conf = this.server.getRaftConf();
        if (conf.isTransitional()) {
            this.replicateNewConf();
        } else {
            this.pendingRequests.replySetConfiguration(this.server::newSuccessReply);
            if (!conf.containsInConf(this.server.getId(), RaftProtos.RaftPeerRole.FOLLOWER, RaftProtos.RaftPeerRole.LISTENER)) {
                this.lease.getAndSetEnabled(false);
                RaftServer.Division.LOG.info("{} is not included in the new configuration {}. Will shutdown server...", (Object)this, (Object)conf);
                try {
                    this.server.properties().minRpcTimeout().sleep();
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                this.server.close();
            }
        }
    }

    private void replicateNewConf() {
        RaftConfigurationImpl conf = this.server.getRaftConf();
        RaftConfigurationImpl newConf = RaftConfigurationImpl.newBuilder().setConf(conf).setLogEntryIndex(this.raftLog.getNextIndex()).build();
        this.updateSenders(newConf);
        this.appendConfiguration(newConf);
        this.notifySenders();
    }

    private long[] getSorted(List<FollowerInfo> followerInfos, boolean includeSelf, ToLongFunction<FollowerInfo> getFollowerIndex, LongSupplier getLogIndex) {
        int length;
        int n = length = includeSelf ? followerInfos.size() + 1 : followerInfos.size();
        if (length == 0) {
            throw new IllegalArgumentException("followerInfos is empty and includeSelf == " + includeSelf);
        }
        long[] indices = new long[length];
        for (int i = 0; i < followerInfos.size(); ++i) {
            indices[i] = getFollowerIndex.applyAsLong(followerInfos.get(i));
        }
        if (includeSelf) {
            indices[length - 1] = getLogIndex.getAsLong();
        }
        Arrays.sort(indices);
        return indices;
    }

    private void checkPeersForYieldingLeader() {
        RaftConfigurationImpl conf = this.server.getRaftConf();
        RaftPeer leader = conf.getPeer(this.server.getId(), new RaftProtos.RaftPeerRole[0]);
        if (leader == null) {
            RaftServer.Division.LOG.error("{} the leader {} is not in the conf {}", new Object[]{this, this.server.getId(), conf});
            return;
        }
        int leaderPriority = leader.getPriority();
        ArrayList<LogAppender> highestPriorityInfos = new ArrayList<LogAppender>();
        int highestPriority = Integer.MIN_VALUE;
        for (LogAppender logAppender : this.senders) {
            int followerPriority;
            RaftPeer follower = conf.getPeer(logAppender.getFollowerId(), new RaftProtos.RaftPeerRole[0]);
            if (follower == null || (followerPriority = follower.getPriority()) <= leaderPriority || followerPriority < highestPriority) continue;
            if (followerPriority > highestPriority) {
                highestPriority = followerPriority;
                highestPriorityInfos.clear();
            }
            highestPriorityInfos.add(logAppender);
        }
        TermIndex leaderLastEntry = this.server.getState().getLastEntry();
        LogAppender appender = LeaderStateImpl.chooseUpToDateFollower(highestPriorityInfos, leaderLastEntry);
        if (appender != null) {
            this.server.getTransferLeadership().start(appender);
        }
    }

    public boolean checkLeadership() {
        if (!this.server.getRole().getLeaderState().filter(leader -> leader == this).isPresent()) {
            return false;
        }
        if (this.server.getRole().getRoleElapsedTimeMs() < (long)this.server.getMaxTimeoutMs()) {
            return true;
        }
        List<RaftPeerId> activePeers = this.getLogAppenders().filter(sender -> sender.getFollower().getLastRpcResponseTime().elapsedTimeMs() <= (long)this.server.getMaxTimeoutMs()).map(LogAppender::getFollowerId).collect(Collectors.toList());
        RaftConfigurationImpl conf = this.server.getRaftConf();
        if (conf.hasMajority(activePeers, this.server.getId())) {
            return true;
        }
        RaftServer.Division.LOG.warn(this + ": Lost leadership on term: " + this.currentTerm + ". Election timeout: " + this.server.getMaxTimeoutMs() + "ms. In charge for: " + this.server.getRole().getRoleElapsedTimeMs() + "ms. Conf: " + conf);
        this.getLogAppenders().map(LogAppender::getFollower).forEach(f -> RaftServer.Division.LOG.warn("Follower {}", f));
        this.stepDown(this.currentTerm, LeaderState.StepDownReason.LOST_MAJORITY_HEARTBEATS);
        return false;
    }

    CompletableFuture<Long> getReadIndex(Long readAfterWriteConsistentIndex) {
        long readIndex = readAfterWriteConsistentIndex != null ? readAfterWriteConsistentIndex.longValue() : this.server.getRaftLog().getLastCommittedIndex();
        RaftServer.Division.LOG.debug("readIndex={}, readAfterWriteConsistentIndex={}", (Object)readIndex, (Object)readAfterWriteConsistentIndex);
        if (this.server.getRaftConf().isSingleton()) {
            return CompletableFuture.completedFuture(readIndex);
        }
        if (!this.isReady()) {
            return ((StartupLogEntry)this.startupLogEntry.get()).getAppliedIndexFuture();
        }
        if (this.hasLease()) {
            return CompletableFuture.completedFuture(readIndex);
        }
        ReadIndexHeartbeats.AppendEntriesListener listener = this.readIndexHeartbeats.addAppendEntriesListener(readIndex, i -> new ReadIndexHeartbeats.AppendEntriesListener((long)i, this.senders));
        if (listener == null) {
            return CompletableFuture.completedFuture(readIndex);
        }
        return listener.getFuture();
    }

    public void onAppendEntriesReply(LogAppender appender, RaftProtos.AppendEntriesReplyProto reply) {
        this.readIndexHeartbeats.onAppendEntriesReply(appender, reply, this::hasMajority);
    }

    boolean getAndSetLeaseEnabled(boolean newValue) {
        return this.lease.getAndSetEnabled(newValue);
    }

    boolean hasLease() {
        if (!this.lease.isEnabled()) {
            return false;
        }
        if (this.checkLeaderLease()) {
            return true;
        }
        RaftConfigurationImpl conf = this.server.getRaftConf();
        CurrentOldFollowerInfos info = this.followerInfoMap.getFollowerInfos(conf);
        this.lease.extend(info.getCurrent(), info.getOld(), peers -> conf.hasMajority((Collection<RaftPeerId>)peers, this.server.getId()));
        return this.checkLeaderLease();
    }

    private boolean checkLeaderLease() {
        return this.isRunning() && this.isReady() && (this.server.getRaftConf().isSingleton() || this.lease.isValid());
    }

    void replyPendingRequest(TermIndex termIndex, RaftClientReply reply) {
        this.pendingRequests.replyPendingRequest(termIndex, reply);
    }

    TransactionContext getTransactionContext(TermIndex termIndex) {
        return this.pendingRequests.getTransactionContext(termIndex);
    }

    long[] getFollowerNextIndices() {
        return this.getLogAppenders().mapToLong(s -> s.getFollower().getNextIndex()).toArray();
    }

    long[] getFollowerMatchIndices() {
        return this.getLogAppenders().mapToLong(s -> s.getFollower().getMatchIndex()).toArray();
    }

    static Map<RaftPeerId, RaftPeer> newMap(Collection<RaftPeer> peers, String str) {
        Objects.requireNonNull(peers, () -> str + " == null");
        HashMap<RaftPeerId, RaftPeer> map = new HashMap<RaftPeerId, RaftPeer>();
        for (RaftPeer p : peers) {
            map.put(p.getId(), p);
        }
        return Collections.unmodifiableMap(map);
    }

    Stream<RaftPeer> getFollowers() {
        return this.getLogAppenders().map(sender -> sender.getFollower().getPeer()).filter(peer -> this.server.getRaftConf().containsInConf(peer.getId(), new RaftProtos.RaftPeerRole[0]));
    }

    Stream<LogAppender> getLogAppenders() {
        return StreamSupport.stream(this.senders.spliterator(), false);
    }

    Optional<LogAppender> getLogAppender(RaftPeerId id) {
        return this.getLogAppenders().filter(a -> a.getFollowerId().equals((Object)id)).findAny();
    }

    private static boolean isCaughtUp(FollowerInfo follower) {
        return ((FollowerInfoImpl)follower).isCaughtUp();
    }

    public void checkHealth(FollowerInfo follower) {
        TimeDuration elapsedTime = follower.getLastRpcResponseTime().elapsedTime();
        if (elapsedTime.compareTo(this.server.properties().rpcSlownessTimeout()) > 0) {
            RaftProtos.RoleInfoProto leaderInfo = this.server.getInfo().getRoleInfoProto();
            this.server.getStateMachine().leaderEvent().notifyFollowerSlowness(leaderInfo);
            this.server.getStateMachine().leaderEvent().notifyFollowerSlowness(leaderInfo, follower.getPeer());
        }
        RaftPeerId followerId = follower.getId();
        this.raftServerMetrics.recordFollowerHeartbeatElapsedTime(followerId, elapsedTime.toLong(TimeUnit.NANOSECONDS));
    }

    public String toString() {
        return this.name;
    }

    private class ConfigurationStagingState {
        private final String name;
        private final Map<RaftPeerId, RaftPeer> newPeers;
        private final Map<RaftPeerId, RaftPeer> newListeners;
        private final PeerConfiguration newConf;

        ConfigurationStagingState(Collection<RaftPeer> newPeers, Collection<RaftPeer> newListeners, PeerConfiguration newConf) {
            this.name = ServerStringUtils.generateUnifiedName(LeaderStateImpl.this.server.getMemberId(), this.getClass());
            this.newPeers = LeaderStateImpl.newMap(newPeers, "peer");
            this.newListeners = LeaderStateImpl.newMap(newListeners, "listeners");
            this.newConf = newConf;
        }

        RaftConfigurationImpl generateOldNewConf(RaftConfigurationImpl current, long logIndex) {
            return RaftConfigurationImpl.newBuilder().setConf(this.newConf).setOldConf(current).setLogEntryIndex(logIndex).build();
        }

        Collection<RaftPeer> getNewPeers() {
            return this.newPeers.values();
        }

        Collection<RaftPeer> getNewListeners() {
            return this.newListeners.values();
        }

        boolean contains(RaftPeerId peerId) {
            return this.newPeers.containsKey(peerId) || this.newListeners.containsKey(peerId);
        }

        void fail(BootStrapProgress progress) {
            String message = this + ": Fail to set configuration " + this.newConf + " due to " + (Object)((Object)progress);
            RaftServer.Division.LOG.debug(message);
            LeaderStateImpl.this.stopAndRemoveSenders(s -> !LeaderStateImpl.isCaughtUp(s.getFollower()));
            LeaderStateImpl.this.stagingState = null;
            LeaderStateImpl.this.pendingRequests.failSetConfiguration((RaftException)new ReconfigurationTimeoutException(message));
        }

        public String toString() {
            return this.name;
        }
    }

    static class MinMajorityMax {
        private final long min;
        private final long majority;
        private final long max;

        MinMajorityMax(long min, long majority, long max) {
            this.min = min;
            this.majority = majority;
            this.max = max;
        }

        MinMajorityMax combine(MinMajorityMax that) {
            return new MinMajorityMax(Math.min(this.min, that.min), Math.min(this.majority, that.majority), Math.min(this.max, that.max));
        }

        static MinMajorityMax valueOf(long[] sorted) {
            return new MinMajorityMax(sorted[0], MinMajorityMax.getMajority(sorted), MinMajorityMax.getMax(sorted));
        }

        static MinMajorityMax valueOf(long[] sorted, long gapThreshold) {
            long majority = MinMajorityMax.getMajority(sorted);
            long min = sorted[0];
            if (gapThreshold != -1L && majority - min > gapThreshold) {
                majority = min;
            }
            return new MinMajorityMax(min, majority, MinMajorityMax.getMax(sorted));
        }

        static long getMajority(long[] sorted) {
            return sorted[(sorted.length - 1) / 2];
        }

        static long getMax(long[] sorted) {
            return sorted[sorted.length - 1];
        }
    }

    private class EventProcessor
    extends Daemon {
        public EventProcessor(String name, RaftServerImpl server) {
            super(Daemon.newBuilder().setName(name).setThreadGroup(server.getThreadGroup()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LeaderStateImpl.this.prepare();
            while (LeaderStateImpl.this.isRunning()) {
                StateUpdateEvent event = LeaderStateImpl.this.eventQueue.poll();
                RaftServerImpl raftServerImpl = LeaderStateImpl.this.server;
                synchronized (raftServerImpl) {
                    if (LeaderStateImpl.this.isRunning()) {
                        if (event != null) {
                            event.execute();
                        } else if (LeaderStateImpl.this.inStagingState()) {
                            LeaderStateImpl.this.checkStaging();
                        } else if (LeaderStateImpl.this.checkLeadership()) {
                            LeaderStateImpl.this.checkPeersForYieldingLeader();
                        }
                    }
                }
            }
        }
    }

    private class StartupLogEntry {
        private final long startIndex;
        private final CompletableFuture<Long> appliedIndexFuture;

        private StartupLogEntry() {
            this.startIndex = LeaderStateImpl.this.appendConfiguration(RaftConfigurationImpl.newBuilder().setConf(LeaderStateImpl.this.server.getRaftConf().getConf()).setLogEntryIndex(LeaderStateImpl.this.raftLog.getNextIndex()).build());
            this.appliedIndexFuture = new CompletableFuture();
        }

        CompletableFuture<Long> getAppliedIndexFuture() {
            return this.appliedIndexFuture;
        }

        boolean checkStartIndex(RaftProtos.LogEntryProto logEntry) {
            boolean completed;
            boolean bl = completed = logEntry.getIndex() == this.startIndex && this.appliedIndexFuture.complete(this.startIndex);
            if (completed) {
                RaftServer.Division.LOG.info("Leader {} is ready since appliedIndex == startIndex == {}", (Object)LeaderStateImpl.this, (Object)this.startIndex);
            }
            return completed;
        }

        boolean isApplied() {
            return JavaUtils.isCompletedNormally(this.appliedIndexFuture);
        }
    }

    static class FollowerInfoMap {
        private final Map<RaftPeerId, FollowerInfo> map = new ConcurrentHashMap<RaftPeerId, FollowerInfo>();
        private volatile CurrentOldFollowerInfos followerInfos;

        FollowerInfoMap() {
        }

        void put(RaftPeerId id, FollowerInfo info) {
            this.map.put(id, info);
        }

        CurrentOldFollowerInfos getFollowerInfos(RaftConfigurationImpl conf) {
            CurrentOldFollowerInfos cached = this.followerInfos;
            if (LeaderStateImpl.isSameConf(cached, conf)) {
                return cached;
            }
            return this.update(conf);
        }

        synchronized CurrentOldFollowerInfos update(RaftConfigurationImpl conf) {
            if (!LeaderStateImpl.isSameConf(this.followerInfos, conf)) {
                this.followerInfos = new CurrentOldFollowerInfos(conf, this.getFollowerInfos(conf.getConf()), Optional.ofNullable(conf.getOldConf()).map(this::getFollowerInfos).orElse(null));
            }
            return this.followerInfos;
        }

        private List<FollowerInfo> getFollowerInfos(PeerConfiguration peers) {
            return peers.streamPeerIds().map(this.map::get).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    static class CurrentOldFollowerInfos {
        private final RaftConfigurationImpl conf;
        private final List<FollowerInfo> current;
        private final List<FollowerInfo> old;

        CurrentOldFollowerInfos(RaftConfigurationImpl conf, List<FollowerInfo> current, List<FollowerInfo> old) {
            this.conf = LeaderStateImpl.isSameSize(current, conf.getConf()) && LeaderStateImpl.isSameSize(old, conf.getOldConf()) ? conf : null;
            this.current = Collections.unmodifiableList(current);
            this.old = old == null ? null : Collections.unmodifiableList(old);
        }

        RaftConfigurationImpl getConf() {
            return this.conf;
        }

        List<FollowerInfo> getCurrent() {
            return this.current;
        }

        List<FollowerInfo> getOld() {
            return this.old;
        }
    }

    static class SenderList
    implements Iterable<LogAppender> {
        private final List<LogAppender> senders = new CopyOnWriteArrayList<LogAppender>();

        SenderList() {
        }

        @Override
        public Iterator<LogAppender> iterator() {
            return this.senders.iterator();
        }

        void addAll(Collection<LogAppender> newSenders) {
            if (newSenders.isEmpty()) {
                return;
            }
            Preconditions.assertUnique((Iterable)CollectionUtils.as(this.senders, LogAppender::getFollowerId), (Iterable)CollectionUtils.as(newSenders, LogAppender::getFollowerId));
            boolean changed = this.senders.addAll(newSenders);
            Preconditions.assertTrue((boolean)changed);
        }

        boolean removeAll(Collection<LogAppender> c) {
            return this.senders.removeAll(c);
        }

        CompletableFuture<Void> stopAll() {
            return CompletableFuture.allOf((CompletableFuture[])this.senders.stream().map(LogAppender::stopAsync).toArray(CompletableFuture[]::new));
        }
    }

    private class EventQueue {
        private final String name;
        private final BlockingQueue<StateUpdateEvent> queue;

        private EventQueue() {
            this.name = ServerStringUtils.generateUnifiedName(LeaderStateImpl.this.server.getMemberId(), this.getClass());
            this.queue = new ArrayBlockingQueue<StateUpdateEvent>(StateUpdateEvent.Type.values().length);
        }

        synchronized void submit(StateUpdateEvent event) {
            if (this.queue.contains(event)) {
                return;
            }
            try {
                this.queue.put(event);
            }
            catch (InterruptedException e) {
                RaftServer.Division.LOG.info("{}: Interrupted when submitting {} ", (Object)this, (Object)event);
                Thread.currentThread().interrupt();
            }
        }

        StateUpdateEvent poll() {
            try {
                return this.queue.poll(LeaderStateImpl.this.server.getMaxTimeoutMs(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                String s = this + ": poll() is interrupted";
                if (LeaderStateImpl.this.isStopped.get()) {
                    RaftServer.Division.LOG.info(s + " gracefully");
                    return null;
                }
                throw new IllegalStateException(s + " UNEXPECTEDLY", ie);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    static class StateUpdateEvent {
        private final Type type;
        private final Runnable handler;

        StateUpdateEvent(Type type, Runnable handler) {
            this.type = type;
            this.handler = handler;
        }

        void execute() {
            this.handler.run();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StateUpdateEvent)) {
                return false;
            }
            StateUpdateEvent that = (StateUpdateEvent)obj;
            return this.type == that.type;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return this.type.name();
        }

        private static enum Type {
            STEP_DOWN,
            UPDATE_COMMIT,
            CHECK_STAGING;

        }
    }

    private static enum BootStrapProgress {
        NOPROGRESS,
        PROGRESSING,
        CAUGHTUP;

    }
}

