/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.activemq.artemis.jakarta.client;

import java.util.Map;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.plugin.activemq.artemis.jakarta.client.define.EnhanceInfo;

public class MessageConsumerConstructorInterceptor
implements InstanceConstructorInterceptor {
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PORT = "61616";
    private static final String HOST_KEY = "host";
    private static final String PORT_KEY = "port";

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) throws Throwable {
        ActiveMQConnection connection = (ActiveMQConnection)allArguments[1];
        ActiveMQDestination destination = (ActiveMQDestination)allArguments[5];
        Map paramMap = connection.getSessionFactory().getConnectorConfiguration().getParams();
        EnhanceInfo enhanceInfo = new EnhanceInfo();
        enhanceInfo.setBrokerUrl(paramMap.getOrDefault(HOST_KEY, DEFAULT_HOST) + ":" + paramMap.getOrDefault(PORT_KEY, DEFAULT_PORT));
        enhanceInfo.setName(destination.getName());
        enhanceInfo.setAddress(destination.getAddress());
        enhanceInfo.setType(destination.getType());
        objInst.setSkyWalkingDynamicField((Object)enhanceInfo);
    }
}

