/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.ognl;

import ognl.PropertyAccessor;
import org.apache.tiles.core.util.CombinedBeanInfo;
import org.apache.tiles.ognl.PropertyAccessorDelegateFactory;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;

public class TilesContextPropertyAccessorDelegateFactory
implements PropertyAccessorDelegateFactory<Request> {
    private final PropertyAccessor objectPropertyAccessor;
    private final PropertyAccessor applicationContextPropertyAccessor;
    private final PropertyAccessor anyScopePropertyAccessor;
    private final PropertyAccessor scopePropertyAccessor;
    private final CombinedBeanInfo beanInfo = new CombinedBeanInfo(Request.class, ApplicationContext.class);

    public TilesContextPropertyAccessorDelegateFactory(PropertyAccessor objectPropertyAccessor, PropertyAccessor applicationContextPropertyAccessor, PropertyAccessor anyScopePropertyAccessor, PropertyAccessor scopePropertyAccessor) {
        this.objectPropertyAccessor = objectPropertyAccessor;
        this.applicationContextPropertyAccessor = applicationContextPropertyAccessor;
        this.anyScopePropertyAccessor = anyScopePropertyAccessor;
        this.scopePropertyAccessor = scopePropertyAccessor;
    }

    @Override
    public PropertyAccessor getPropertyAccessor(String propertyName, Request request) {
        PropertyAccessor retValue;
        String scopeName;
        if (propertyName.endsWith("Scope") && request.getContext(scopeName = propertyName.substring(0, propertyName.length() - 5)) != null) {
            return this.scopePropertyAccessor;
        }
        if (this.beanInfo.getMappedDescriptors(Request.class).containsKey(propertyName)) {
            retValue = this.objectPropertyAccessor;
        } else if (this.beanInfo.getMappedDescriptors(ApplicationContext.class).containsKey(propertyName)) {
            retValue = this.applicationContextPropertyAccessor;
        } else {
            return this.anyScopePropertyAccessor;
        }
        return retValue;
    }
}

