/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;

public class PlaceholderNode
extends Expression {
    private final String name;
    private final String example;
    private final Expression content;

    public PlaceholderNode(Node fromNode, String name, String example, Expression content) {
        super(fromNode, content.getSchema());
        this.name = Preconditions.checkNotNull(name);
        this.example = Preconditions.checkNotNull(example);
        this.content = Preconditions.checkNotNull(content);
    }

    public String getName() {
        return this.name;
    }

    public String getExample() {
        return this.example;
    }

    public Expression getContent() {
        return this.content;
    }

    public PlaceholderNode withContent(Expression newContent) {
        return newContent.equals(this.content) ? this : new PlaceholderNode(this, this.name, this.example, newContent);
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitPlaceholderNode(this);
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof PlaceholderNode && this.equals((PlaceholderNode)that);
    }

    public boolean equals(PlaceholderNode that) {
        return this.equalsExpression(that) && Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getExample(), that.getExample()) && Objects.equal(this.getContent(), that.getContent());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.getName(), this.getExample(), this.getContent());
    }
}

