/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Call;
import com.google.gxp.compiler.base.CallVisitor;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.ExhaustiveExpressionVisitor;
import com.google.gxp.compiler.reparent.Attribute;
import java.util.List;
import java.util.Map;

public class BoundCall
extends Call {
    private final Callable callee;

    public BoundCall(SourcePosition sourcePosition, String displayName, Callable callee, Map<String, Attribute> attributes, List<String> attrBundles) {
        super(sourcePosition, displayName, Preconditions.checkNotNull(callee.getSchema()), attributes, attrBundles);
        this.callee = Preconditions.checkNotNull(callee);
    }

    public BoundCall(Call fromCall, Callable callee, Map<String, Attribute> attributes) {
        super(fromCall.getSourcePosition(), fromCall.getDisplayName(), Preconditions.checkNotNull(callee.getSchema()), attributes, fromCall.getAttrBundles());
        this.callee = Preconditions.checkNotNull(callee);
    }

    public Callable getCallee() {
        return this.callee;
    }

    public BoundCall withParams(Map<String, Attribute> newAttributes) {
        return Objects.equal(this.getAttributes(), newAttributes) ? this : new BoundCall(this.getSourcePosition(), this.getDisplayName(), this.callee, newAttributes, this.getAttrBundles());
    }

    @Override
    public Call transformParams(ExhaustiveExpressionVisitor visitor) {
        ImmutableMap.Builder<String, Attribute> mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Attribute> param : this.getAttributes().entrySet()) {
            mapBuilder.put(param.getKey(), visitor.visitAttribute(param.getValue()));
        }
        return this.withParams(mapBuilder.build());
    }

    @Override
    public final <T> T acceptCallVisitor(CallVisitor<T> visitor) {
        return visitor.visitBoundCall(this);
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof BoundCall && this.equals((BoundCall)that);
    }

    public boolean equals(BoundCall that) {
        return this.equalsCall(that) && Objects.equal(this.callee, that.callee);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.callHashCode(), this.callee);
    }
}

