/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml.print;

import java.util.function.Consumer;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.xml.print.BoxLoader;
import net.sf.jasperreports.engine.xml.print.EllipseLoader;
import net.sf.jasperreports.engine.xml.print.GenericElementLoader;
import net.sf.jasperreports.engine.xml.print.ImageLoader;
import net.sf.jasperreports.engine.xml.print.LineLoader;
import net.sf.jasperreports.engine.xml.print.RectangleLoader;
import net.sf.jasperreports.engine.xml.print.ReportElementLoader;
import net.sf.jasperreports.engine.xml.print.TextLoader;
import net.sf.jasperreports.engine.xml.print.XmlLoader;

public class FrameLoader {
    private static final FrameLoader INSTANCE = new FrameLoader();

    public static FrameLoader instance() {
        return INSTANCE;
    }

    public void loadFrame(XmlLoader xmlLoader, JasperPrint jasperPrint, Consumer<? super JRPrintFrame> consumer) {
        JRBasePrintFrame frame = new JRBasePrintFrame(jasperPrint.getDefaultStyleProvider());
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "reportElement": {
                    ReportElementLoader.instance().loadReportElement(xmlLoader, jasperPrint, frame);
                    break;
                }
                case "box": {
                    BoxLoader.instance().loadBox(xmlLoader, frame.getLineBox());
                    break;
                }
                case "line": {
                    LineLoader.instance().loadLine(xmlLoader, jasperPrint, frame::addElement);
                    break;
                }
                case "rectangle": {
                    RectangleLoader.instance().loadRectangle(xmlLoader, jasperPrint, frame::addElement);
                    break;
                }
                case "ellipse": {
                    EllipseLoader.instance().loadEllipse(xmlLoader, jasperPrint, frame::addElement);
                    break;
                }
                case "image": {
                    ImageLoader.instance().loadImage(xmlLoader, jasperPrint, frame::addElement);
                    break;
                }
                case "text": {
                    TextLoader.instance().loadText(xmlLoader, jasperPrint, frame::addElement);
                    break;
                }
                case "frame": {
                    FrameLoader.instance().loadFrame(xmlLoader, jasperPrint, frame::addElement);
                    break;
                }
                case "genericElement": {
                    GenericElementLoader.instance().loadGenericElement(xmlLoader, jasperPrint, frame::addElement);
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
        consumer.accept(frame);
    }
}

