/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseGraphicElement;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseImage
extends JRBaseGraphicElement
implements JRImage {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LAZY = "isLazy";
    public static final String PROPERTY_ON_ERROR_TYPE = "onErrorType";
    public static final String PROPERTY_USING_CACHE = "isUsingCache";
    protected ScaleImageEnum scaleImage;
    protected RotationEnum rotation;
    protected HorizontalImageAlignEnum horizontalImageAlign;
    protected VerticalImageAlignEnum verticalImageAlign;
    protected Boolean isUsingCache;
    protected boolean isLazy;
    protected OnErrorTypeEnum onErrorType = OnErrorTypeEnum.ERROR;
    protected EvaluationTimeEnum evaluationTime;
    protected String linkType;
    protected String linkTarget;
    private JRHyperlinkParameter[] hyperlinkParameters;
    protected JRLineBox lineBox;
    protected String evaluationGroup;
    protected JRExpression expression;
    protected JRExpression anchorNameExpression;
    protected JRExpression bookmarkLevelExpression;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkWhenExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    private JRExpression hyperlinkTooltipExpression;
    protected int bookmarkLevel = 0;

    protected JRBaseImage(JRImage image, JRBaseObjectFactory factory) {
        super(image, factory);
        this.scaleImage = image.getOwnScaleImage();
        this.rotation = image.getOwnRotation();
        this.horizontalImageAlign = image.getOwnHorizontalImageAlign();
        this.verticalImageAlign = image.getOwnVerticalImageAlign();
        this.isUsingCache = image.getUsingCache();
        this.isLazy = image.isLazy();
        this.onErrorType = image.getOnErrorType();
        this.evaluationTime = image.getEvaluationTime();
        this.linkType = image.getLinkType();
        this.linkTarget = image.getLinkTarget();
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(image, factory);
        this.lineBox = image.getLineBox().clone(this);
        this.evaluationGroup = image.getEvaluationGroup();
        this.expression = factory.getExpression(image.getExpression());
        this.anchorNameExpression = factory.getExpression(image.getAnchorNameExpression());
        this.bookmarkLevelExpression = factory.getExpression(image.getBookmarkLevelExpression());
        this.hyperlinkReferenceExpression = factory.getExpression(image.getHyperlinkReferenceExpression());
        this.hyperlinkWhenExpression = factory.getExpression(image.getHyperlinkWhenExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(image.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(image.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(image.getHyperlinkTooltipExpression());
        this.bookmarkLevel = image.getBookmarkLevel();
    }

    @Override
    public ModeEnum getMode() {
        return this.getStyleResolver().getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public ScaleImageEnum getScaleImage() {
        return this.getStyleResolver().getScaleImage(this);
    }

    @Override
    public ScaleImageEnum getOwnScaleImage() {
        return this.scaleImage;
    }

    @Override
    public void setScaleImage(ScaleImageEnum scaleImage) {
        ScaleImageEnum old = this.scaleImage;
        this.scaleImage = scaleImage;
        this.getEventSupport().firePropertyChange("scaleImage", old, this.scaleImage);
    }

    @Override
    public RotationEnum getRotation() {
        return this.getStyleResolver().getRotation(this);
    }

    @Override
    public RotationEnum getOwnRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(RotationEnum rotation) {
        RotationEnum old = this.rotation;
        this.rotation = rotation;
        this.getEventSupport().firePropertyChange("rotation", old, this.rotation);
    }

    @Override
    public HorizontalImageAlignEnum getHorizontalImageAlign() {
        return this.getStyleResolver().getHorizontalImageAlign(this);
    }

    @Override
    public HorizontalImageAlignEnum getOwnHorizontalImageAlign() {
        return this.horizontalImageAlign;
    }

    @Override
    public void setHorizontalImageAlign(HorizontalImageAlignEnum horizontalImageAlign) {
        HorizontalImageAlignEnum old = this.horizontalImageAlign;
        this.horizontalImageAlign = horizontalImageAlign;
        this.getEventSupport().firePropertyChange("horizontalImageAlignment", old, this.horizontalImageAlign);
    }

    @Override
    public VerticalImageAlignEnum getVerticalImageAlign() {
        return this.getStyleResolver().getVerticalImageAlign(this);
    }

    @Override
    public VerticalImageAlignEnum getOwnVerticalImageAlign() {
        return this.verticalImageAlign;
    }

    @Override
    public void setVerticalImageAlign(VerticalImageAlignEnum verticalImageAlign) {
        VerticalImageAlignEnum old = this.verticalImageAlign;
        this.verticalImageAlign = verticalImageAlign;
        this.getEventSupport().firePropertyChange("verticalImageAlignment", old, this.verticalImageAlign);
    }

    @Override
    public Boolean getUsingCache() {
        return this.isUsingCache;
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
        Boolean old = this.isUsingCache;
        this.isUsingCache = isUsingCache;
        this.getEventSupport().firePropertyChange(PROPERTY_USING_CACHE, old, this.isUsingCache);
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public void setLazy(boolean isLazy) {
        boolean old = this.isLazy;
        this.isLazy = isLazy;
        this.getEventSupport().firePropertyChange(PROPERTY_LAZY, old, this.isLazy);
    }

    @Override
    public OnErrorTypeEnum getOnErrorType() {
        return this.onErrorType;
    }

    @Override
    public void setOnErrorType(OnErrorTypeEnum onErrorType) {
        OnErrorTypeEnum old = this.onErrorType;
        this.onErrorType = onErrorType;
        this.getEventSupport().firePropertyChange(PROPERTY_ON_ERROR_TYPE, old, this.onErrorType);
    }

    @Override
    public EvaluationTimeEnum getEvaluationTime() {
        return this.evaluationTime;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    @Override
    public HyperlinkTargetEnum getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    @Override
    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    @Override
    public JRExpression getBookmarkLevelExpression() {
        return this.bookmarkLevelExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkWhenExpression() {
        return this.hyperlinkWhenExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitImage(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_0;
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    @Override
    public Object clone() {
        JRBaseImage clone = (JRBaseImage)super.clone();
        clone.lineBox = this.lineBox.clone(clone);
        clone.hyperlinkParameters = (JRHyperlinkParameter[])JRCloneUtils.cloneArray((JRCloneable[])this.hyperlinkParameters);
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.anchorNameExpression = JRCloneUtils.nullSafeClone(this.anchorNameExpression);
        clone.bookmarkLevelExpression = JRCloneUtils.nullSafeClone(this.bookmarkLevelExpression);
        clone.hyperlinkReferenceExpression = JRCloneUtils.nullSafeClone(this.hyperlinkReferenceExpression);
        clone.hyperlinkWhenExpression = JRCloneUtils.nullSafeClone(this.hyperlinkWhenExpression);
        clone.hyperlinkAnchorExpression = JRCloneUtils.nullSafeClone(this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = JRCloneUtils.nullSafeClone(this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = JRCloneUtils.nullSafeClone(this.hyperlinkTooltipExpression);
        return clone;
    }
}

