/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.type;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import net.sf.jasperreports.engine.type.EnumUtil;
import net.sf.jasperreports.engine.type.NamedEnum;

public class NamedEnumConstantDeserializer
extends StdScalarDeserializer<Object> {
    private static final long serialVersionUID = 1L;

    public NamedEnumConstantDeserializer(JavaType type) {
        super(type);
        if (this._valueClass == null || !NamedEnum.class.isAssignableFrom(this._valueClass) || !Enum.class.isAssignableFrom(this._valueClass)) {
            throw new IllegalArgumentException(type + " needs to be a NamedEnum");
        }
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        String textValue = node.textValue();
        NamedEnum value = EnumUtil.getEnumByName((NamedEnum[])((NamedEnum[])this._valueClass.getEnumConstants()), (String)textValue);
        if (value == null) {
            try {
                value = Enum.valueOf(this._valueClass, textValue);
            }
            catch (IllegalArgumentException e) {
                return ctxt.handleWeirdStringValue(this._valueClass, textValue, "not one of the values accepted for enum %s", new Object[]{this._valueClass});
            }
        }
        return value;
    }
}

