/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.SaveContributorFactory;

public class JRSingleSheetXlsxSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_XLSX = ".xlsx";

    public JRSingleSheetXlsxSaveContributor(JasperReportsContext jasperReportsContext, Locale locale, ResourceBundle resBundle) {
        super(jasperReportsContext, locale, resBundle);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(EXTENSION_XLSX);
    }

    @Override
    public String getDescription() {
        return this.getBundleString("file.desc.xlsx.single.sheet");
    }

    @Override
    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().toLowerCase().endsWith(EXTENSION_XLSX)) {
            file = new File(file.getAbsolutePath() + EXTENSION_XLSX);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(this.getBundleString("file.exists"), file.getName()), this.getBundleString("save"), 2)) {
            JRXlsxExporter exporter = new JRXlsxExporter(this.getJasperReportsContext());
            exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
            exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(file));
            SimpleXlsxReportConfiguration configuration = new SimpleXlsxReportConfiguration();
            configuration.setOnePagePerSheet(false);
            exporter.setConfiguration(configuration);
            exporter.exportReport();
        }
    }

    public static class Factory
    implements SaveContributorFactory {
        @Override
        public JRSaveContributor create(JasperReportsContext jasperReportsContext, Locale locale, ResourceBundle resBundle) {
            return new JRSingleSheetXlsxSaveContributor(jasperReportsContext, locale, resBundle);
        }
    }
}

