/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.text;

import java.util.Objects;
import java.util.ResourceBundle;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.locale.LocaleProviderFactory;
import org.apache.struts2.text.LocalizedTextProvider;
import org.apache.struts2.text.ResourceBundleTextProvider;
import org.apache.struts2.text.TextProvider;
import org.apache.struts2.text.TextProviderFactory;
import org.apache.struts2.text.TextProviderSupport;

public class StrutsTextProviderFactory
implements TextProviderFactory {
    protected LocaleProviderFactory localeProviderFactory;
    protected LocalizedTextProvider localizedTextProvider;
    protected TextProvider defaultTextProvider;

    @Inject
    public void setLocaleProviderFactory(LocaleProviderFactory localeProviderFactory) {
        this.localeProviderFactory = localeProviderFactory;
    }

    @Inject
    public void setLocalizedTextProvider(LocalizedTextProvider localizedTextProvider) {
        this.localizedTextProvider = localizedTextProvider;
    }

    @Inject(required=false)
    public void setDefaultTextProvider(TextProvider defaultTextProvider) {
        this.defaultTextProvider = defaultTextProvider;
    }

    @Override
    public TextProvider createInstance(Class<?> clazz) {
        TextProvider instance = this.getTextProvider(clazz);
        if (instance instanceof ResourceBundleTextProvider) {
            ((ResourceBundleTextProvider)instance).setClazz(clazz);
            ((ResourceBundleTextProvider)instance).setLocaleProvider(this.localeProviderFactory.createLocaleProvider());
        }
        return instance;
    }

    @Override
    public TextProvider createInstance(ResourceBundle bundle) {
        TextProvider instance = this.getTextProvider(bundle);
        if (instance instanceof ResourceBundleTextProvider) {
            ((ResourceBundleTextProvider)instance).setBundle(bundle);
            ((ResourceBundleTextProvider)instance).setLocaleProvider(this.localeProviderFactory.createLocaleProvider());
        }
        return instance;
    }

    protected TextProvider getTextProvider(Class clazz) {
        return Objects.requireNonNullElseGet(this.defaultTextProvider, () -> new TextProviderSupport(clazz, this.localeProviderFactory.createLocaleProvider(), this.localizedTextProvider));
    }

    protected TextProvider getTextProvider(ResourceBundle bundle) {
        return Objects.requireNonNullElseGet(this.defaultTextProvider, () -> new TextProviderSupport(bundle, this.localeProviderFactory.createLocaleProvider(), this.localizedTextProvider));
    }
}

