/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dwg;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

class JulianDateUtil {
    private static final double NANOS_PER_DAY = 8.64E13;
    public static final Instant REDUCED_JD = ZonedDateTime.of(1858, 11, 16, 12, 0, 0, 0, ZoneOffset.UTC).toInstant();
    public static final Instant JULIAN_DATE = REDUCED_JD.minus(2400000L, ChronoUnit.DAYS);
    private final Instant epoch;

    private JulianDateUtil(Instant epoch) {
        this.epoch = epoch;
    }

    private Instant toInstant(double day) {
        long l = (long)day;
        return this.epoch.plus(l, ChronoUnit.DAYS).plusNanos(Math.round((day - (double)l) * 8.64E13));
    }

    public static Instant toInstant(long julianDay, long millisecondsIntoDay) {
        return new JulianDateUtil(JULIAN_DATE).toInstant(Double.parseDouble(julianDay + "." + millisecondsIntoDay));
    }
}

