/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.util;

public class DurationFormatUtils {
    public static String formatMillis(long duration) {
        duration = Math.abs(duration);
        StringBuilder sb = new StringBuilder();
        int secs = (int)(duration / 1000L) % 60;
        int mins = (int)(duration / 60000L % 60L);
        int hrs = (int)(duration / 3600000L % 24L);
        int days = (int)(duration / 86400000L % 7L);
        DurationFormatUtils.addUnitString(sb, days, "day");
        DurationFormatUtils.addUnitString(sb, hrs, "hour");
        DurationFormatUtils.addUnitString(sb, mins, "minute");
        DurationFormatUtils.addUnitString(sb, secs, "second");
        if (duration < 1000L) {
            DurationFormatUtils.addUnitString(sb, duration, "millisecond");
        }
        return sb.toString();
    }

    private static void addUnitString(StringBuilder sb, long unit, String unitString) {
        if (unit == 1L) {
            DurationFormatUtils.addComma(sb);
            sb.append("1 ");
            sb.append(unitString);
        } else if (unit > 1L) {
            DurationFormatUtils.addComma(sb);
            sb.append(unit);
            sb.append(" ");
            sb.append(unitString);
            sb.append("s");
        }
    }

    private static void addComma(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
    }
}

