/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.modules.Page;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.assemblerbroker.TurbineAssemblerBroker;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.RunData;

public class PageLoader
extends GenericLoader
implements Loader {
    private static final long serialVersionUID = 272783554001103941L;
    private static Log log = LogFactory.getLog((Class)PageLoader.class);
    private static PageLoader instance = new PageLoader(Turbine.getConfiguration().getInt("page.cache.size", 5));
    private static AssemblerBrokerService ab = TurbineAssemblerBroker.getService();

    private PageLoader() {
    }

    private PageLoader(int i) {
        super(i);
    }

    private void addInstance(String name, Page page) {
        if (this.cache()) {
            this.put(name, page);
        }
    }

    public void exec(RunData data, String name) throws Exception {
        this.getInstance(name).build(data);
    }

    public Assembler getAssembler(String name) throws Exception {
        return this.getInstance(name);
    }

    public Page getInstance(String name) throws Exception {
        Page page = null;
        if (this.cache() && this.containsKey(name)) {
            page = (Page)this.get(name);
            log.debug((Object)("Found Page " + name + " in the cache!"));
        } else {
            log.debug((Object)("Loading Page " + name + " from the Assembler Broker"));
            try {
                if (ab != null) {
                    page = (Page)ab.getAssembler("page", name);
                }
            }
            catch (ClassCastException cce) {
                page = null;
            }
            if (page == null) {
                List packages = Turbine.getConfiguration().getList("module.packages");
                ObjectUtils.addOnce(packages, GenericLoader.getBasePackage());
                throw new ClassNotFoundException("\n\n\tRequested Page not found: " + name + "\n\tTurbine looked in the following " + "modules.packages path: \n\t" + packages.toString() + "\n");
            }
            if (this.cache()) {
                this.addInstance(name, page);
            }
        }
        return page;
    }

    public static PageLoader getInstance() {
        return instance;
    }
}

