/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.transform;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.intake.transform.DTDResolver;
import org.apache.turbine.services.intake.xmlmodel.AppData;
import org.apache.turbine.services.intake.xmlmodel.Rule;
import org.apache.turbine.services.intake.xmlmodel.XmlField;
import org.apache.turbine.services.intake.xmlmodel.XmlGroup;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToAppData
extends DefaultHandler {
    private static Log log = LogFactory.getLog((Class)XmlToAppData.class);
    private AppData app = new AppData();
    private XmlGroup currGroup = null;
    private XmlField currField = null;
    private Rule currRule = null;
    private StringBuffer charBuffer = null;
    private static SAXParserFactory saxFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppData parseFile(String xmlFile) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = saxFactory.newSAXParser();
        FileReader fr = new FileReader(xmlFile);
        BufferedReader br = new BufferedReader(fr);
        try {
            InputSource is = new InputSource(br);
            parser.parse(is, (DefaultHandler)this);
        }
        finally {
            br.close();
        }
        return this.app;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return new DTDResolver().resolveEntity(publicId, systemId);
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        this.charBuffer = new StringBuffer();
        if (rawName.equals("input-data")) {
            this.app.loadFromXML(attributes);
        } else if (rawName.equals("group")) {
            this.currGroup = this.app.addGroup(attributes);
        } else if (rawName.equals("field")) {
            this.currField = this.currGroup.addField(attributes);
        } else if (rawName.equals("rule")) {
            this.currRule = this.currField.addRule(attributes);
        }
    }

    public void characters(char[] mesgArray, int start, int length) {
        this.charBuffer.append(mesgArray, start, length);
    }

    public void endElement(String uri, String localName, String rawName) {
        if (this.charBuffer.length() > 0) {
            String cdata = this.charBuffer.toString().trim();
            if ("rule".equals(rawName)) {
                this.currRule.setMessage(cdata);
            } else if ("required-message".equals(rawName)) {
                log.warn((Object)"The required-message element is deprecated!  You should update your intake.xml file to use the 'required' rule instead.");
                this.currField.setIfRequiredMessage(cdata);
            }
        }
    }

    public void warning(SAXParseException spe) {
        StringBuffer sb = new StringBuffer(64);
        sb.append("Parser Exception: Line ");
        sb.append(spe.getLineNumber());
        sb.append(" Row ");
        sb.append(spe.getColumnNumber());
        sb.append(" Msg: ");
        sb.append(spe.getMessage());
        log.warn((Object)sb.toString());
    }

    public void error(SAXParseException spe) {
        StringBuffer sb = new StringBuffer(64);
        sb.append("Parser Exception: Line ");
        sb.append(spe.getLineNumber());
        sb.append(" Row ");
        sb.append(spe.getColumnNumber());
        sb.append(" Msg: ");
        sb.append(spe.getMessage());
        log.error((Object)sb.toString());
    }

    public void fatalError(SAXParseException spe) {
        StringBuffer sb = new StringBuffer(64);
        sb.append("Parser Exception: Line ");
        sb.append(spe.getLineNumber());
        sb.append(" Row ");
        sb.append(spe.getColumnNumber());
        sb.append(" Msg: ");
        sb.append(spe.getMessage());
        log.fatal((Object)sb.toString());
    }

    static {
        saxFactory = SAXParserFactory.newInstance();
        saxFactory.setValidating(true);
    }
}

