/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.services.xslt.XSLTService;
import org.w3c.dom.Node;

public class TurbineXSLTService
extends TurbineBaseService
implements XSLTService {
    protected boolean caching = false;
    protected String path;
    private LRUMap cache = new LRUMap(20);
    private static TransformerFactory tfactory;

    public void init() throws InitializationException {
        Configuration conf = this.getConfiguration();
        this.path = conf.getString("path", "/");
        this.caching = conf.getBoolean("cache", false);
        tfactory = TransformerFactory.newInstance();
        this.setInit(true);
    }

    private URL getStyleURL(String style) {
        int colon;
        StringBuffer sb = new StringBuffer(128);
        if (StringUtils.isNotEmpty((String)this.path)) {
            if (this.path.charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(this.path);
            if (this.path.charAt(this.path.length() - 1) != '/') {
                sb.append('/');
            }
        } else {
            sb.append('/');
        }
        if ((colon = style.lastIndexOf(".")) > 0) {
            sb.append(style.substring(0, colon));
        } else {
            sb.append(style);
        }
        sb.append(".xsl");
        return TurbineServlet.getResource(sb.toString());
    }

    protected Templates compileTemplates(URL source) throws Exception {
        InputStream in = source.openStream();
        StreamSource xslin = new StreamSource(in, source.toString());
        Templates root = TransformerFactory.newInstance().newTemplates(xslin);
        in.close();
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Templates getTemplates(String xslName) throws Exception {
        LRUMap lRUMap = this.cache;
        synchronized (lRUMap) {
            if (this.caching && this.cache.containsKey((Object)xslName)) {
                return (Templates)this.cache.get((Object)xslName);
            }
        }
        URL url = this.getStyleURL(xslName);
        if (url == null) {
            return null;
        }
        Templates sr = this.compileTemplates(url);
        LRUMap lRUMap2 = this.cache;
        synchronized (lRUMap2) {
            if (this.caching) {
                this.cache.put((Object)xslName, (Object)sr);
            }
        }
        return sr;
    }

    protected void transform(String style, Source in, Result out, Map params) throws TransformerException, IOException, Exception {
        Transformer transformer;
        Templates styleTemplate = this.getTemplates(style);
        Transformer transformer2 = transformer = styleTemplate != null ? styleTemplate.newTransformer() : tfactory.newTransformer();
        if (params != null) {
            Iterator it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                transformer.setParameter(String.valueOf(entry.getKey()), entry.getValue());
            }
        }
        transformer.transform(in, out);
    }

    public void transform(String xslName, Reader in, Writer out) throws Exception {
        StreamSource xmlin = new StreamSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout, null);
    }

    public String transform(String xslName, Reader in) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw);
        return sw.toString();
    }

    public void transform(String xslName, Node in, Writer out) throws Exception {
        DOMSource xmlin = new DOMSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout, null);
    }

    public String transform(String xslName, Node in) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw);
        return sw.toString();
    }

    public void transform(String xslName, Reader in, Writer out, Map params) throws Exception {
        StreamSource xmlin = new StreamSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout, params);
    }

    public String transform(String xslName, Reader in, Map params) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw, params);
        return sw.toString();
    }

    public void transform(String xslName, Node in, Writer out, Map params) throws Exception {
        DOMSource xmlin = new DOMSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout, params);
    }

    public String transform(String xslName, Node in, Map params) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw, params);
        return sw.toString();
    }
}

