/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;

public final class Transaction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$torque$util$Transaction == null ? (class$org$apache$torque$util$Transaction = Transaction.class$("org.apache.torque.util.Transaction")) : class$org$apache$torque$util$Transaction));
    static /* synthetic */ Class class$org$apache$torque$util$Transaction;

    private Transaction() {
    }

    public static Connection begin() throws TorqueException {
        return Transaction.begin(Torque.getDefaultDB());
    }

    public static Connection begin(String dbName) throws TorqueException {
        return Transaction.beginOptional(dbName, true);
    }

    public static Connection beginOptional(String dbName, boolean useTransaction) throws TorqueException {
        Connection con = Torque.getConnection(dbName);
        try {
            if (con.getMetaData().supportsTransactions() && useTransaction) {
                con.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
        return con;
    }

    public static void commit(Connection con) throws TorqueException {
        if (con == null) {
            throw new NullPointerException("Connection object was null. This could be due to a misconfiguration of the DataSourceFactory. Check the logs and Torque.properties to better determine the cause.");
        }
        try {
            if (con.getMetaData().supportsTransactions() && !con.getAutoCommit()) {
                con.commit();
                con.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
        finally {
            Torque.closeConnection(con);
        }
    }

    public static void rollback(Connection con) throws TorqueException {
        if (con == null) {
            throw new TorqueException("Connection object was null. This could be due to a misconfiguration of the DataSourceFactory. Check the logs and Torque.properties to better determine the cause.");
        }
        try {
            if (con.getMetaData().supportsTransactions() && !con.getAutoCommit()) {
                con.rollback();
                con.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            log.error((Object)"An attempt was made to rollback a transaction but the database did not allow the operation to be rolled back.", (Throwable)e);
            throw new TorqueException(e);
        }
        finally {
            Torque.closeConnection(con);
        }
    }

    public static void safeRollback(Connection con) {
        if (con == null) {
            log.debug((Object)"called safeRollback with null argument");
        } else {
            try {
                Transaction.rollback(con);
            }
            catch (TorqueException e) {
                log.warn((Object)"An error occured during rollback.", (Throwable)((Object)e));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

