/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.template.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.services.template.mapper.BaseMapper;
import org.apache.turbine.services.template.mapper.Mapper;
import org.apache.turbine.util.TurbineException;

public class ClassMapper
extends BaseMapper
implements Mapper {
    private Loader<? extends Assembler> loader = null;
    private static final Logger log = LogManager.getLogger(ClassMapper.class);

    public Loader<? extends Assembler> getLoader() {
        return this.loader;
    }

    public void setLoader(Loader<? extends Assembler> loader) {
        this.loader = loader;
        log.debug("Loader is {}", this.loader);
    }

    @Override
    public String doMapping(String template) {
        log.debug("doMapping({})", (Object)template);
        ArrayList<String> components = new ArrayList<String>(Arrays.asList(StringUtils.split((String)template, (String)String.valueOf(','))));
        int componentSize = components.size() - 1;
        String className = (String)components.get(componentSize);
        components.remove(componentSize--);
        log.debug("className is {}", (Object)className);
        int dotIndex = className.lastIndexOf(46);
        className = dotIndex < 0 ? className : className.substring(0, dotIndex);
        boolean firstRun = !className.equals("Default");
        while (true) {
            String pkg = StringUtils.join(components.iterator(), (String)String.valueOf(this.separator));
            StringBuilder testName = new StringBuilder();
            log.debug("classPackage is now: {}", (Object)pkg);
            if (!components.isEmpty()) {
                testName.append(pkg);
                testName.append(this.separator);
            }
            testName.append(firstRun ? className : "Default");
            log.debug("Looking for {}", (Object)testName);
            try {
                this.loader.getAssembler(testName.toString());
                log.debug("Found it, returning {}", (Object)testName);
                return testName.toString();
            }
            catch (TurbineException e) {
                log.error("Turbine Exception Class mapping", (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (firstRun) {
                firstRun = false;
                continue;
            }
            if (components.isEmpty()) break;
            components.remove(componentSize--);
        }
        log.debug("Returning default");
        return this.getDefaultName(template);
    }
}

