/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.factory;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationUtil;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainer;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerConfiguration;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public class ServiceContainerFactory {
    private static Logger logger;

    public static ServiceContainer create(ServiceContainerConfiguration serviceManagerConfig) throws Exception {
        Validate.notNull(serviceManagerConfig, "serviceManagerConfig");
        Context context = serviceManagerConfig.createFinalContext();
        return ServiceContainerFactory.create(serviceManagerConfig, context);
    }

    public static ServiceContainer create(ServiceContainerConfiguration serviceManagerConfig, Context context) throws Exception {
        Validate.notNull(serviceManagerConfig, "serviceManagerConfig");
        Validate.notNull(context, "context");
        Class<?> clazz = null;
        Configuration configuration = null;
        ServiceContainer result = null;
        try {
            logger = serviceManagerConfig.getLogger();
            configuration = serviceManagerConfig.createFinalConfiguration();
            String clazzName = ServiceContainerFactory.getServiceContainerClazzName(configuration);
            logger.debug("Loading the service container class " + clazzName);
            clazz = ServiceContainerFactory.class.getClassLoader().loadClass(clazzName);
            logger.debug("Instantiating the service container class " + clazzName);
            result = (ServiceContainer)clazz.newInstance();
        }
        catch (Exception e) {
            String msg = "Creating the ServiceContainer failed";
            logger.error(msg, (Throwable)e);
            throw e;
        }
        Logger serviceContainerLogger = serviceManagerConfig.getLogger();
        serviceContainerLogger.debug("Using the following configuration : " + ConfigurationUtil.toString((Configuration)configuration));
        ContainerUtil.enableLogging((Object)result, (Logger)serviceManagerConfig.getLogger());
        ContainerUtil.contextualize((Object)result, (Context)context);
        if (serviceManagerConfig.getParentServiceManager() != null) {
            ContainerUtil.service((Object)result, (ServiceManager)serviceManagerConfig.getParentServiceManager());
        }
        ContainerUtil.configure((Object)result, (Configuration)configuration);
        ContainerUtil.initialize((Object)result);
        return result;
    }

    public static boolean dispose(ServiceContainer container) {
        try {
            if (container != null) {
                container.dispose();
            }
            return true;
        }
        catch (Throwable t) {
            String msg = "Disposing the container failed : " + t.getMessage();
            System.err.println(msg);
            t.printStackTrace();
            return false;
        }
    }

    private static String getServiceContainerClazzName(Configuration configuration) {
        Configuration containerClazzNameConfig = configuration.getChild("containerClazzName");
        if (containerClazzNameConfig != null) {
            return containerClazzNameConfig.getValue("org.apache.fulcrum.yaafi.framework.container.ServiceContainerImpl");
        }
        return "org.apache.fulcrum.yaafi.framework.container.ServiceContainerImpl";
    }
}

