/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.codec.string;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.python.netty.buffer.ByteBuf;
import org.python.netty.buffer.ByteBufUtil;
import org.python.netty.channel.ChannelHandler;
import org.python.netty.channel.ChannelHandlerContext;
import org.python.netty.handler.codec.MessageToMessageEncoder;
import org.python.netty.handler.codec.string.LineSeparator;
import org.python.netty.util.CharsetUtil;
import org.python.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class LineEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;
    private final byte[] lineSeparator;

    public LineEncoder() {
        this(LineSeparator.DEFAULT, CharsetUtil.UTF_8);
    }

    public LineEncoder(LineSeparator lineSeparator) {
        this(lineSeparator, CharsetUtil.UTF_8);
    }

    public LineEncoder(Charset charset2) {
        this(LineSeparator.DEFAULT, charset2);
    }

    public LineEncoder(LineSeparator lineSeparator, Charset charset2) {
        this.charset = ObjectUtil.checkNotNull(charset2, "charset");
        this.lineSeparator = ObjectUtil.checkNotNull(lineSeparator, "lineSeparator").value().getBytes(charset2);
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg2, List<Object> out) throws Exception {
        ByteBuf buffer = ByteBufUtil.encodeString(ctx.alloc(), CharBuffer.wrap(msg2), this.charset, this.lineSeparator.length);
        buffer.writeBytes(this.lineSeparator);
        out.add(buffer);
    }
}

