/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.assemblerbroker.util.java;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.services.assemblerbroker.util.AssemblerFactory;

public abstract class JavaBaseFactory<T extends Assembler>
implements AssemblerFactory<T> {
    private static List<String> packages = GenericLoader.getPackages();
    protected Logger log = LogManager.getLogger(this.getClass());
    private final ConcurrentHashMap<String, Class<T>> classCache = new ConcurrentHashMap();

    public T getAssembler(String packageName, String name) {
        Assembler assembler = null;
        this.log.debug("Class Fragment is {}", (Object)name);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            for (String p : packages) {
                StringBuilder sb = new StringBuilder();
                sb.append(p).append('.').append(packageName).append('.').append(name);
                String className = sb.toString();
                this.log.debug("Trying {}", (Object)className);
                try {
                    Class<T> _servClass;
                    Class<Object> servClass = this.classCache.get(className);
                    if (servClass == null && (_servClass = this.classCache.putIfAbsent(className, servClass = Class.forName(className))) != null) {
                        servClass = _servClass;
                    }
                    assembler = (Assembler)servClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    this.log.debug("{}: Not found", (Object)className);
                }
                catch (NoClassDefFoundError ncdfe) {
                    this.log.debug("{}: No Class Definition found", (Object)className);
                }
                catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    this.log.error("Could not load {}", (Object)className, (Object)e);
                    break;
                }
            }
        }
        this.log.debug("Returning: {}", assembler);
        return (T)assembler;
    }

    @Override
    public abstract Loader<T> getLoader();

    @Override
    public int getCacheSize() {
        return this.getLoader().getCacheSize();
    }
}

