/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.core.Py;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.Untraversable;
import org.python.core.codecs;

@Untraversable
public class SyspathArchive
extends PyString {
    private ZipFile zipFile;

    public SyspathArchive(String archiveName) throws IOException {
        super(Py.fileSystemEncode(archiveName).getString());
        archiveName = SyspathArchive.getArchiveName(archiveName);
        if (archiveName == null) {
            throw new IOException("path '" + archiveName + "' not an archive");
        }
        this.zipFile = new ZipFile(new File(archiveName));
        if (PySystemState.isPackageCacheEnabled()) {
            PySystemState.packageManager.addJar(archiveName, true);
        }
    }

    SyspathArchive(ZipFile zipFile, String path) {
        super(TYPE, PyString.charsFitWidth(path, 7) ? path : codecs.PyUnicode_EncodeUTF8(path, null), true);
        this.zipFile = zipFile;
    }

    static SyspathArchive fromPath(String path) throws IOException {
        String archiveName = SyspathArchive.getArchiveName(path);
        if (archiveName == null) {
            throw new IOException(path);
        }
        ZipFile zipFile = new ZipFile(new File(archiveName));
        if (PySystemState.isPackageCacheEnabled()) {
            PySystemState.packageManager.addJar(archiveName, true);
        }
        return new SyspathArchive(zipFile, path);
    }

    static String getArchiveName(String dir) {
        String lowerName = dir.toLowerCase();
        int idx = lowerName.indexOf(".zip");
        if (idx < 0) {
            idx = lowerName.indexOf(".jar");
        }
        if (idx >= 0) {
            if (idx == dir.length() - 4) {
                return dir;
            }
            char ch = dir.charAt(idx + 4);
            if (ch == File.separatorChar || ch == '/') {
                return dir.substring(0, idx + 4);
            }
        }
        return null;
    }

    public SyspathArchive makeSubfolder(String folder) {
        return new SyspathArchive(this.zipFile, super.toString() + "/" + folder);
    }

    private String makeEntry(String entry) {
        String archive = super.toString();
        String folder = SyspathArchive.getArchiveName(super.toString());
        if (archive.length() == folder.length()) {
            return entry;
        }
        return archive.substring(folder.length() + 1) + "/" + entry;
    }

    ZipEntry getEntry(String entryName) {
        return this.zipFile.getEntry(this.makeEntry(entryName));
    }

    public String asUriCompatibleString() {
        String result2 = this.__str__().toString();
        if (File.separatorChar == '\\') {
            return result2.replace(File.separatorChar, '/');
        }
        return result2;
    }

    InputStream getInputStream(ZipEntry entry) throws IOException {
        int l;
        int len;
        InputStream istream = this.zipFile.getInputStream(entry);
        byte[] buffer = new byte[len];
        int off = 0;
        for (len = (int)entry.getSize(); len > 0; len -= l) {
            l = istream.read(buffer, off, buffer.length - off);
            if (l < 0) {
                return null;
            }
            off += l;
        }
        istream.close();
        return new ByteArrayInputStream(buffer);
    }
}

