/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.dynamic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.ACLFactory;
import org.apache.fulcrum.security.model.dynamic.DynamicAccessControlList;
import org.apache.fulcrum.security.model.dynamic.DynamicAccessControlListImpl;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicGroup;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicRole;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicUser;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class DynamicACLFactory
extends AbstractManager
implements ACLFactory {
    @Override
    public <T extends AccessControlList> T getAccessControlList(User user) {
        HashMap<Group, RoleSet> roleSets = new HashMap<Group, RoleSet>();
        HashMap<Role, PermissionSet> permissionSets = new HashMap<Role, PermissionSet>();
        HashSet<DynamicUser> users = new HashSet<DynamicUser>();
        users.add((DynamicUser)user);
        this.addDelegators((DynamicUser)user, users);
        for (DynamicUser aUser : users) {
            this.addRolesAndPermissions(aUser, roleSets, permissionSets);
        }
        try {
            DynamicAccessControlList aclInstance = this.getAclInstance(roleSets, permissionSets);
            return (T)aclInstance;
        }
        catch (UnknownEntityException uue) {
            throw new RuntimeException(uue.getMessage(), uue);
        }
    }

    private DynamicAccessControlList getAclInstance(Map<? extends Group, ? extends RoleSet> roles, Map<? extends Role, ? extends PermissionSet> permissions) throws UnknownEntityException {
        DynamicAccessControlListImpl accessControlList;
        try {
            accessControlList = new DynamicAccessControlListImpl(roles, permissions);
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate an ACL implementation object", e);
        }
        return accessControlList;
    }

    public <T extends DynamicUser> void addDelegators(DynamicUser user, Set<T> users) {
        for (User u : user.getDelegators()) {
            DynamicUser delegatorUser = (DynamicUser)u;
            if (!users.add(delegatorUser)) continue;
            this.addDelegators(delegatorUser, users);
        }
    }

    private void addRolesAndPermissions(User user, Map<Group, RoleSet> roleSets, Map<Role, PermissionSet> permissionSets) {
        for (Group group : ((DynamicUser)user).getGroups()) {
            RoleSet roleSet = ((DynamicGroup)group).getRoles();
            roleSets.put(group, roleSet);
            for (Role r : roleSet) {
                DynamicRole role = (DynamicRole)r;
                permissionSets.put(role, role.getPermissions());
            }
        }
    }
}

