/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.bool;

import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.bool.AbstractBooleanExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class SimpleBooleanFunction
extends AbstractBooleanExpression {
    private String op;
    private IBooleanExpression e1;
    private IBooleanExpression e2;

    public SimpleBooleanFunction(String text, IBooleanExpression e1, IBooleanExpression e2) {
        this.op = text;
        this.e1 = e1;
        this.e2 = e2;
    }

    @Override
    public boolean getBooleanValue(MatchContext context, RutaStream stream) {
        boolean b1 = this.e1.getBooleanValue(context, stream);
        boolean b2 = this.e2.getBooleanValue(context, stream);
        if ("XOR".equals(this.op)) {
            return !(!b1 && !b2 || b1 && b2);
        }
        if ("==".equals(this.op)) {
            return b1 == b2;
        }
        if ("!=".equals(this.op)) {
            return b1 != b2;
        }
        return false;
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        return this.e1.getStringValue(context, stream) + " " + this.op + " " + this.e2.getStringValue(context, stream);
    }
}

