/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.Rejectable;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.apache.camel.util.concurrent.RejectableFutureTask;

public class RejectableScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    public RejectableScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
    }

    public RejectableScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public RejectableScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public RejectableScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        if (runnable instanceof Rejectable) {
            return new RejectableFutureTask<T>(runnable, value);
        }
        return super.newTaskFor(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable instanceof Rejectable) {
            return new RejectableFutureTask<T>(callable);
        }
        return super.newTaskFor(callable);
    }

    @Override
    public String toString() {
        if (this.getThreadFactory() instanceof CamelThreadFactory) {
            String name = ((CamelThreadFactory)this.getThreadFactory()).getName();
            return super.toString() + "[" + name + "]";
        }
        return super.toString();
    }
}

