/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Objects;
import org.apache.wicket.markup.head.AbstractCspHeaderItem;
import org.apache.wicket.markup.head.CssContentHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.CssUrlReferenceHeaderItem;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class CssHeaderItem
extends AbstractCspHeaderItem {
    private static final long serialVersionUID = 1L;
    private String markupId;

    public String getId() {
        return this.markupId;
    }

    public CssHeaderItem setId(String markupId) {
        this.markupId = markupId;
        return this;
    }

    public static CssReferenceHeaderItem forReference(ResourceReference reference) {
        return CssHeaderItem.forReference(reference, null);
    }

    public static CssReferenceHeaderItem forReference(ResourceReference reference, String media) {
        return CssHeaderItem.forReference(reference, null, media);
    }

    public static CssReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String media) {
        return new CssReferenceHeaderItem(reference, pageParameters, media);
    }

    public static CssReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String media, String rel) {
        return new CssReferenceHeaderItem(reference, pageParameters, media, rel);
    }

    public static CssContentHeaderItem forCSS(CharSequence css, String id) {
        return new CssContentHeaderItem(css, id);
    }

    public static CssUrlReferenceHeaderItem forUrl(String url) {
        return CssHeaderItem.forUrl(url, null);
    }

    public static CssUrlReferenceHeaderItem forUrl(String url, String media) {
        return new CssUrlReferenceHeaderItem(url, media);
    }

    public static CssUrlReferenceHeaderItem forUrl(String url, String media, String rel) {
        return new CssUrlReferenceHeaderItem(url, media, rel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CssHeaderItem that = (CssHeaderItem)o;
        return Objects.equals(this.markupId, that.markupId);
    }

    public int hashCode() {
        return Objects.hash(this.markupId);
    }
}

