/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.IResourceUrlSanitizer;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.danekja.java.util.function.serializable.SerializableSupplier;

public abstract class ResourceReference
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final Key data;

    public ResourceReference(Key key) {
        Args.notNull(key, "key");
        this.data = key;
    }

    public ResourceReference(Class<?> scope, String name, Locale locale, String style, String variation) {
        Args.notNull(scope, "scope");
        Args.notNull(name, "name");
        this.data = new Key(scope.getName(), name, locale, style, variation);
    }

    public ResourceReference(Class<?> scope, String name) {
        this(scope, name, null, null, null);
    }

    public ResourceReference(String name) {
        this(Application.class, name, null, null, null);
    }

    public final Key getKey() {
        return this.data;
    }

    public String getName() {
        return this.data.getName();
    }

    public final String getExtension() {
        int extPos;
        String name = this.getName();
        int queryAt = name.indexOf(63);
        if (queryAt != -1) {
            name = name.substring(0, queryAt);
        }
        if ((extPos = name.lastIndexOf(46)) == -1) {
            return null;
        }
        return name.substring(extPos + 1).toLowerCase(Locale.ROOT);
    }

    public Class<?> getScope() {
        return WicketObjects.resolveClass(this.data.getScope());
    }

    public Locale getLocale() {
        return this.data.getLocale();
    }

    public String getStyle() {
        return this.data.getStyle();
    }

    public String getVariation() {
        return this.data.getVariation();
    }

    public boolean canBeRegistered() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceReference)) {
            return false;
        }
        ResourceReference that = (ResourceReference)obj;
        return Objects.equal(this.data, that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public abstract IResource getResource();

    public UrlAttributes getUrlAttributes() {
        return new UrlAttributes(this.getLocale(), this.getStyle(), this.getVariation());
    }

    public static final ResourceReference of(String name, SerializableSupplier<IResource> resourceSupplier) {
        return new LambdaResourceReference(name, resourceSupplier);
    }

    public static final ResourceReference of(Key key, SerializableSupplier<IResource> resourceSupplier) {
        return new LambdaResourceReference(key, resourceSupplier);
    }

    public String toString() {
        return this.data.toString();
    }

    public List<HeaderItem> getDependencies() {
        return new ArrayList<HeaderItem>();
    }

    public static class Key
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String scope;
        private final String name;
        private final Locale locale;
        private final String style;
        private final String variation;

        public Key(ResourceReference reference) {
            this(reference.getScope().getName(), reference.getName(), reference.getLocale(), reference.getStyle(), reference.getVariation());
        }

        public Key(String scope, String name, Locale locale, String style, String variation) {
            Args.notNull(scope, "scope");
            Args.notNull(name, "name");
            this.scope = scope.intern();
            this.name = name.intern();
            this.locale = locale;
            this.style = style != null ? style.intern() : null;
            this.variation = variation != null ? variation.intern() : null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return Objects.equal(this.scope, that.scope) && Objects.equal(this.name, that.name) && Objects.equal(this.locale, that.locale) && Objects.equal(this.style, that.style) && Objects.equal(this.variation, that.variation);
        }

        public int hashCode() {
            int result = this.scope != null ? this.scope.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
            result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
            result = 31 * result + (this.variation != null ? this.variation.hashCode() : 0);
            return result;
        }

        public final String getScope() {
            return this.scope;
        }

        public final Class<?> getScopeClass() {
            return WicketObjects.resolveClass(this.scope);
        }

        public final String getName() {
            return this.name;
        }

        public final Locale getLocale() {
            return this.locale;
        }

        public final String getStyle() {
            return this.style;
        }

        public final String getVariation() {
            return this.variation;
        }

        public String toString() {
            return "scope: " + this.scope + "; name: " + this.name + "; locale: " + String.valueOf(this.locale) + "; style: " + this.style + "; variation: " + this.variation;
        }
    }

    public static class UrlAttributes {
        private final Locale locale;
        private final String style;
        private final String variation;

        public UrlAttributes(Locale locale, String style, String variation) {
            this.locale = locale;
            this.style = style;
            this.variation = variation;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getStyle() {
            return this.style;
        }

        public String getVariation() {
            return this.variation;
        }

        public UrlAttributes sanitize(Class<?> scope, String name) {
            IResourceUrlSanitizer sanitizer = Application.get().getResourceSettings().getUrlSanitizer();
            return sanitizer == null ? this : sanitizer.sanitize(this, scope, name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UrlAttributes)) {
                return false;
            }
            UrlAttributes that = (UrlAttributes)obj;
            return Objects.equal(this.getLocale(), that.getLocale()) && Objects.equal(this.getStyle(), that.getStyle()) && Objects.equal(this.getVariation(), that.getVariation());
        }

        public int hashCode() {
            int result = this.locale != null ? this.locale.hashCode() : 0;
            result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
            result = 31 * result + (this.variation != null ? this.variation.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "locale: " + String.valueOf(this.locale) + "; style: " + this.style + "; variation: " + this.variation;
        }
    }

    public static final class LambdaResourceReference
    extends ResourceReference {
        private static final long serialVersionUID = 1826862147241009289L;
        final SerializableSupplier<IResource> resourceBuilder;

        public LambdaResourceReference(String name, SerializableSupplier<IResource> resourceBuilder) {
            super(name);
            this.resourceBuilder = Args.notNull(resourceBuilder, "resourceBuilder");
        }

        public LambdaResourceReference(Key key, SerializableSupplier<IResource> resourceBuilder) {
            super(key);
            this.resourceBuilder = Args.notNull(resourceBuilder, "resourceBuilder");
        }

        @Override
        public IResource getResource() {
            return (IResource)this.resourceBuilder.get();
        }
    }
}

