/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.mock;

import java.util.LinkedList;
import java.util.List;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPageStore;

public class MockPageStore
implements IPageStore {
    private final LinkedList<IManageablePage> pages = new LinkedList();

    @Override
    public boolean supportsVersioning() {
        return true;
    }

    @Override
    public void destroy() {
        this.pages.clear();
    }

    public List<IManageablePage> getPages() {
        return this.pages;
    }

    @Override
    public IManageablePage getPage(IPageContext context, int id) {
        for (IManageablePage page : this.pages) {
            if (page.getPageId() != id) continue;
            return page;
        }
        return null;
    }

    @Override
    public void removePage(IPageContext context, IManageablePage page) {
        for (IManageablePage candidate : this.pages) {
            if (candidate.getPageId() != page.getPageId()) continue;
            this.pages.remove(candidate);
            return;
        }
    }

    @Override
    public void removeAllPages(IPageContext context) {
        this.pages.clear();
    }

    @Override
    public boolean canBeAsynchronous(IPageContext context) {
        return true;
    }

    @Override
    public void addPage(IPageContext context, IManageablePage page) {
        this.removePage(context, page);
        this.pages.addLast(page);
    }
}

