#ifndef INCLUDE_CONFIG_MANAGER_H
#define INCLUDE_CONFIG_MANAGER_H
/* ----------------------------------------------------------------------------
 * config manager.h
 * prototypes and definitions for the configuration manager.
 *
 * Copyright 2002-2005 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <stdio.h>
#include "pbblist.h"

#define FLG_RONLY	1<<0
#define FLG_INVBOOL	1<<1

enum datatype { DT_INT, DT_STRING, DT_KEY, DT_BOOL, DT_INVBOOL, DT_LIST };

struct cfgsection {
	int sectionid;
	char *name;
};

struct cfgoption {
	int  sectionid;
	char *name;
	long tag1;
	long tag2;
	enum datatype type;
	char *comment;
	char **items;
	int itemscnt;
	int readonly;
};

/* prototypes */
int configmanager_init ();
int configmanager_exit ();

/* registers a new configuration file section or
 * get the section id of an existing one.
 */
int registerCfgSection (char *name);
struct cfgoption *findCfgOption (char *name);
char *prependString (char **address, char *text);

/* register a new configuration option. The call will
 * be ignored, if the option has already been registered.
 */
int registerCfgOptionInt (int sid, char *name, long tag, int flags, char *comment);
int registerCfgOptionString (int sid, char *name, long tag, int flags, char *comment);
int registerCfgOptionKey (int sid, char *name, long tag1, long tag2, int flags, char *comment);
int registerCfgOptionBool (int sid, char *name, long tag, int flags, char *comment);
int registerCfgOptionList (int sid, char *name, long tag, int flags, char *comment, ...);

int registerCfgOption (int sid, char *name, int datatype, long tag1, long tag2, int flags, char *comment);

/* read configuration file and helpers
 */
struct tagitem *readConfigFile (char *filename);
void readCfgInt (struct cfgoption *option, struct tagitem **taglist, char **strptr, char *arg);
void readCfgString (struct cfgoption *option, struct tagitem **taglist, char **strptr, char *arg);
void readCfgKey (struct cfgoption *option, struct tagitem **taglist, char **strptr, char *arg);
void decode_key_and_modifier(char *arg, int *key, int *mod);
void readCfgBool (struct cfgoption *option, struct tagitem **taglist, char **strptr, char *arg);
void readCfgList (struct cfgoption *option, struct tagitem **taglist, char **strptr, char *arg);

/* write configuration file and helpers
 */
void writeConfigFile (char *filename);
void writeCfgInt (FILE *fd, struct cfgoption *option, struct tagitem *taglist);
void writeCfgString (FILE *fd, struct cfgoption *option, struct tagitem *taglist);
void writeCfgKey (FILE *fd, struct cfgoption *option, struct tagitem *taglist);
char *code_key_and_modifier (int key, int mod);
void writeCfgBool (FILE *fd, struct cfgoption *option, struct tagitem *taglist);
void writeCfgList (FILE *fd, struct cfgoption *option, struct tagitem *taglist);

#endif    /* INCLUDE_CONFIG_MANAGER_H */

