/*
 * Copyright (c) 2010 Kungliga Tekniska Högskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Portions Copyright (c) 2010 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "netlogon.h"

OM_uint32 _netlogon_inquire_context (
            OM_uint32 * minor_status,
            gss_const_ctx_id_t context_handle,
            gss_name_t * src_name,
            gss_name_t * targ_name,
            OM_uint32 * lifetime_rec,
            gss_OID * mech_type,
            OM_uint32 * ctx_flags,
            int * locally_initiated,
            int * open_context
           )
{
    const gssnetlogon_ctx ctx = (const gssnetlogon_ctx)context_handle;
    OM_uint32 ret;

    if (src_name != NULL) {
        ret = _netlogon_duplicate_name(minor_status, (gss_name_t)ctx->SourceName,
                                       (gss_name_t *)src_name);
        if (GSS_ERROR(ret))
            return ret;
    }
    if (targ_name != NULL) {
        ret = _netlogon_duplicate_name(minor_status, (gss_name_t)ctx->TargetName,
                                       (gss_name_t *)targ_name);
        if (GSS_ERROR(ret))
            return ret;
    }
    if (mech_type != NULL)
        *mech_type = GSS_NETLOGON_MECHANISM;
    if (ctx_flags != NULL)
        *ctx_flags = ctx->GssFlags;
    if (locally_initiated != NULL)
        *locally_initiated = ctx->LocallyInitiated;
    if (open_context != NULL)
        *open_context = (ctx->State == NL_AUTH_ESTABLISHED);

    return GSS_S_COMPLETE;
}

