#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

import importlib.util
import os

from fenrirscreenreader.core.i18n import _

_spec = importlib.util.spec_from_file_location(
    "vmenu_search_base",
    os.path.join(os.path.dirname(__file__), "vmenu_search_base.py"),
)
_module = importlib.util.module_from_spec(_spec)
_spec.loader.exec_module(_module)
vmenu_search_command = _module.vmenu_search_command


class command(vmenu_search_command):
    def __init__(self):
        super().__init__("r")
