;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2024 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

; REQUIRES: pvc-supported, llvm-16-plus

; RUN: llvm-as %s -o %t.bc
; RUN: ocloc compile -llvm_input -file %t.bc -device pvc -options "-cl-intel-enable-auto-large-GRF-mode -igc_opts 'EnableOpaquePointersBackend=1 PrintToConsole=1,PrintAfter=Layout,JointMatrixLoadStoreOpt=2'" 2>&1 | FileCheck %s

target triple = "spir64-unknown-unknown"

%"class.sycl::_V1::ext::oneapi::bfloat16" = type { i16 }

define spir_kernel void @test(ptr addrspace(1) %src_a, ptr addrspace(1) %src_b, ptr addrspace(1) %src_c) !intel_reqd_sub_group_size !100 {
entry:
  %ma1x32 = alloca <2 x i16>
  %a1 = bitcast ptr %ma1x32 to ptr
  %ma32x32 = alloca <64 x i16>
  %a = bitcast ptr %ma32x32 to ptr
  %mb = alloca <64 x i32>
  %b = bitcast ptr %mb to ptr
  %mc1x64 = alloca <4 x float>
  %c1 = bitcast ptr %mc1x64 to ptr
  %mc32x64 = alloca { <64 x float>, <64 x float> }
  %c = bitcast ptr %mc32x64 to ptr

; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
  call void @__builtin_spriv_OpJointMatrixLoadINTEL_PackedA_RowMajor_SG16_1x32_i16_2_global_v8i8_pi32_i32(ptr %a1, ptr addrspace(1) %src_a, i64 32, i32 0)

; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
  call void @__builtin_spriv_OpJointMatrixStoreINTEL_PackedA_RowMajor_SG16_1x32_i16_2_global_pi64_v8i8(ptr addrspace(1) %src_a, ptr %a1, i64 32, i32 0)

; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
; CHECK: call <2 x i16> @llvm.genx.GenISA.simdBlockRead.v2i16.p1(ptr addrspace(1)
  call void @__builtin_spriv_OpJointMatrixLoadINTEL_PackedA_RowMajor_SG16_32x32_i16_64_global_v8i8_pi32_i32(ptr %a, ptr addrspace(1) %src_a, i64 32, i32 0)

; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v2i16(ptr addrspace(1)
  call void @__builtin_spriv_OpJointMatrixStoreINTEL_PackedA_RowMajor_SG16_32x32_i16_64_global_pi64_v8i8(ptr addrspace(1) %src_a, ptr %a, i64 32, i32 0)

; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
  call void @__builtin_spriv_OpJointMatrixLoadINTEL_PackedB_PackedB_SG16_32x64_i16_64_global_v8i8_pi32_i32(ptr %b, ptr addrspace(1) %src_b, i64 128, i32 0)

; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
  call void @__builtin_spriv_OpJointMatrixStoreINTEL_PackedB_PackedB_SG16_32x64_i16_64_global_pi64_v8i8(ptr addrspace(1) %src_b, ptr %b, i64 128, i32 0)

; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
; CHECK: call <4 x i16> @llvm.genx.GenISA.simdBlockRead.v4i16.p1(ptr addrspace(1)
  call void @__builtin_spriv_OpJointMatrixLoadINTEL_PackedB_RowMajor_SG16_32x64_i16_64_global_v8i8_pi32_i32(ptr %b, ptr addrspace(1) %src_b, i64 64, i32 0)

; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i16(ptr addrspace(1)
  call void @__builtin_spriv_OpJointMatrixStoreINTEL_PackedB_RowMajor_SG16_32x64_i16_64_global_pi64_v8i8(ptr addrspace(1) %src_b, ptr %b, i64 64, i32 0)

; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
  call void @__builtin_spriv_OpJointMatrixLoadINTEL_Accumulator_RowMajor_SG16_32x64_i32_128_global_v8i8_pi32_i32(ptr %c, ptr addrspace(1) %src_c, i64 64, i32 0)

; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
  call void @__builtin_spriv_OpJointMatrixStoreINTEL_Accumulator_RowMajor_SG16_32x64_i32_128_global_pi64_v8i8(ptr addrspace(1) %src_c, ptr %c, i64 64, i32 0)

; CHECK: call <4 x i32> @llvm.genx.GenISA.simdBlockRead.v4i32.p1(ptr addrspace(1)
  call void @__builtin_spriv_OpJointMatrixLoadINTEL_Accumulator_RowMajor_SG16_1x64_i32_4_global_v8i8_pi32_i32(ptr %c1, ptr addrspace(1) %src_c, i64 64, i32 0)

; CHECK: call void @llvm.genx.GenISA.simdBlockWrite.p1.v4i32(ptr addrspace(1)
  call void @__builtin_spriv_OpJointMatrixStoreINTEL_Accumulator_RowMajor_SG16_1x64_i32_4_global_pi64_v8i8(ptr addrspace(1) %src_c, ptr %c1, i64 64, i32 0)

  ret void
}

declare void @__builtin_spriv_OpJointMatrixLoadINTEL_PackedA_RowMajor_SG16_1x32_i16_2_global_v8i8_pi32_i32(ptr, ptr addrspace(1), i64, i32)
declare void @__builtin_spriv_OpJointMatrixLoadINTEL_PackedA_RowMajor_SG16_32x32_i16_64_global_v8i8_pi32_i32(ptr, ptr addrspace(1), i64, i32)

declare void @__builtin_spriv_OpJointMatrixLoadINTEL_PackedB_PackedB_SG16_32x64_i16_64_global_v8i8_pi32_i32(ptr, ptr addrspace(1), i64, i32)
declare void @__builtin_spriv_OpJointMatrixLoadINTEL_PackedB_RowMajor_SG16_32x64_i16_64_global_v8i8_pi32_i32(ptr, ptr addrspace(1), i64, i32)

declare void @__builtin_spriv_OpJointMatrixLoadINTEL_Accumulator_RowMajor_SG16_1x64_i32_4_global_v8i8_pi32_i32(ptr, ptr addrspace(1), i64, i32)
declare void @__builtin_spriv_OpJointMatrixLoadINTEL_Accumulator_RowMajor_SG16_32x64_i32_128_global_v8i8_pi32_i32(ptr, ptr addrspace(1), i64, i32)

declare void @__builtin_spriv_OpJointMatrixStoreINTEL_PackedA_RowMajor_SG16_1x32_i16_2_global_pi64_v8i8(ptr addrspace(1), ptr, i64, i32)
declare void @__builtin_spriv_OpJointMatrixStoreINTEL_PackedA_RowMajor_SG16_32x32_i16_64_global_pi64_v8i8(ptr addrspace(1), ptr, i64, i32)

declare void @__builtin_spriv_OpJointMatrixStoreINTEL_PackedB_PackedB_SG16_32x64_i16_64_global_pi64_v8i8(ptr addrspace(1), ptr, i64, i32)
declare void @__builtin_spriv_OpJointMatrixStoreINTEL_PackedB_RowMajor_SG16_32x64_i16_64_global_pi64_v8i8(ptr addrspace(1), ptr, i64, i32)

declare void @__builtin_spriv_OpJointMatrixStoreINTEL_Accumulator_RowMajor_SG16_1x64_i32_4_global_pi64_v8i8(ptr addrspace(1), ptr, i64, i32)
declare void @__builtin_spriv_OpJointMatrixStoreINTEL_Accumulator_RowMajor_SG16_32x64_i32_128_global_pi64_v8i8(ptr addrspace(1), ptr, i64, i32)

!100 = !{i32 16}
