/* SPDX-License-Identifier: GPL-2.0-only WITH Linux-syscall-note */

/* Copyright (C) 2022 Microsoft Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <linux/limits.h>

#ifndef INM_PATH_MAX
#define INM_PATH_MAX PATH_MAX
#endif

#ifndef _IOCTL_H_
#define _IOCTL_H_

#define IOCTL_INMAGE_VOLUME_STACKING            	_IOW(FLT_IOCTL, VOLUME_STACKING_CMD, PROCESS_VOLUME_STACKING_INPUT)
#define IOCTL_INMAGE_PROCESS_START_NOTIFY       	_IOW(FLT_IOCTL, START_NOTIFY_CMD, PROCESS_START_NOTIFY_INPUT)
#define IOCTL_INMAGE_SERVICE_SHUTDOWN_NOTIFY    	_IOW(FLT_IOCTL, SHUTDOWN_NOTIFY_CMD, SHUTDOWN_NOTIFY_INPUT)
#define IOCTL_INMAGE_STOP_FILTERING_DEVICE      	_IOW(FLT_IOCTL, STOP_FILTER_CMD, VOLUME_GUID)
#define IOCTL_INMAGE_START_FILTERING_DEVICE     	_IOW(FLT_IOCTL, START_FILTER_CMD, VOLUME_GUID)
#define IOCTL_INMAGE_START_FILTERING_DEVICE_V2  	_IOW(FLT_IOCTL, START_FILTER_CMD_V2, inm_dev_info_compat_t)
#define IOCTL_INMAGE_FREEZE_VOLUME              	_IOW(FLT_IOCTL, VOLUME_FREEZE_CMD, freeze_info_t)
#define IOCTL_INMAGE_THAW_VOLUME                	_IOW(FLT_IOCTL, VOLUME_THAW_CMD, thaw_info_t)
#define IOCTL_INMAGE_TAG_VOLUME_V2              	_IOWR(FLT_IOCTL, TAG_CMD_V2, tag_info_t_v2)
#define IOCTL_INMAGE_IOBARRIER_TAG_VOLUME       	_IOWR(FLT_IOCTL, TAG_CMD_V3, tag_info_t_v2)
#define IOCTL_INMAGE_CREATE_BARRIER_ALL         	_IOWR(FLT_IOCTL, CREATE_BARRIER, flt_barrier_create_t)
#define IOCTL_INMAGE_REMOVE_BARRIER_ALL         	_IOWR(FLT_IOCTL, REMOVE_BARRIER, flt_barrier_remove_t)
#define IOCTL_INMAGE_TAG_COMMIT_V2              	_IOWR(FLT_IOCTL, TAG_COMMIT_V2, flt_tag_commit_t)

/* Mirror setup related ioctls */
#define IOCTL_INMAGE_START_MIRRORING_DEVICE     	_IOW(FLT_IOCTL, START_MIRROR_CMD, mirror_conf_info_t)
#define IOCTL_INMAGE_STOP_MIRRORING_DEVICE      	_IOW(FLT_IOCTL, STOP_MIRROR_CMD, SCSI_ID)
#define IOCTL_INMAGE_MIRROR_VOLUME_STACKING     	_IOW(FLT_IOCTL, MIRROR_VOLUME_STACKING_CMD, mirror_conf_info_t)
#define IOCTL_INMAGE_MIRROR_EXCEPTION_NOTIFY    	_IOW(FLT_IOCTL, MIRROR_EXCEPTION_NOTIFY_CMD, inm_resync_notify_info_t)
#define IOCTL_INMAGE_MIRROR_TEST_HEARTBEAT      	_IOW(FLT_IOCTL, MIRROR_TEST_HEARTBEAT_CMD, SCSI_ID)
#define IOCTL_INMAGE_BLOCK_AT_LUN			_IOW(FLT_IOCTL, BLOCK_AT_LUN_CMD, inm_at_lun_reconfig_t)

#define IOCTL_INMAGE_GET_DIRTY_BLOCKS_TRANS_V2  	_IOWR(FLT_IOCTL, GET_DB_CMD_V2, UDIRTY_BLOCK_V2)
#define IOCTL_INMAGE_COMMIT_DIRTY_BLOCKS_TRANS  	_IOW(FLT_IOCTL, COMMIT_DB_CMD, COMMIT_TRANSACTION)
#define IOCTL_INMAGE_SET_VOLUME_FLAGS           	_IOW(FLT_IOCTL, SET_VOL_FLAGS_CMD, VOLUME_FLAGS_INPUT)
#define IOCTL_INMAGE_GET_VOLUME_FLAGS           	_IOR(FLT_IOCTL, GET_VOL_FLAGS_CMD, VOLUME_FLAGS_INPUT)
#define IOCTL_INMAGE_WAIT_FOR_DB                	_IOW(FLT_IOCTL, WAIT_FOR_DB_CMD, WAIT_FOR_DB_NOTIFY)
#define IOCTL_INMAGE_CLEAR_DIFFERENTIALS        	_IOW(FLT_IOCTL, CLEAR_DIFFS_CMD, VOLUME_GUID)
#define IOCTL_INMAGE_GET_NANOSECOND_TIME        	_IOWR(FLT_IOCTL, GET_TIME_CMD, long long)
#define IOCTL_INMAGE_UNSTACK_ALL                	_IO(FLT_IOCTL, UNSTACK_ALL_CMD)
#define IOCTL_INMAGE_SYS_PRE_SHUTDOWN       		_IOW(FLT_IOCTL, SYS_PRE_SHUTDOWN_NOTIFY_CMD, void *)
#define IOCTL_INMAGE_SYS_SHUTDOWN               	_IOW(FLT_IOCTL, SYS_SHUTDOWN_NOTIFY_CMD, SYS_SHUTDOWN_NOTIFY_INPUT)
#define IOCTL_INMAGE_TAG_VOLUME                 	_IOWR(FLT_IOCTL, TAG_CMD, unsigned long)
#define IOCTL_INMAGE_SYNC_TAG_VOLUME            	_IOWR(FLT_IOCTL, SYNC_TAG_CMD, unsigned long)
#define IOCTL_INMAGE_GET_TAG_VOLUME_STATUS		_IOWR(FLT_IOCTL, SYNC_TAG_STATUS_CMD, unsigned long)
#define IOCTL_INMAGE_WAKEUP_ALL_THREADS         	_IO(FLT_IOCTL, WAKEUP_THREADS_CMD)
#define IOCTL_INMAGE_GET_DB_NOTIFY_THRESHOLD    	_IOWR(FLT_IOCTL, GET_DB_THRESHOLD_CMD, get_db_thres_t )
#define IOCTL_INMAGE_RESYNC_START_NOTIFICATION  	_IOWR(FLT_IOCTL, RESYNC_START_CMD, RESYNC_START )
#define IOCTL_INMAGE_RESYNC_END_NOTIFICATION    	_IOWR(FLT_IOCTL, RESYNC_END_CMD, RESYNC_END)
#define IOCTL_INMAGE_GET_DRIVER_VERSION         	_IOWR(FLT_IOCTL, GET_DRIVER_VER_CMD, DRIVER_VERSION)
#define IOCTL_INMAGE_SHELL_LOG                  	_IOWR(FLT_IOCTL, GET_SHELL_LOG_CMD, char *)
#define IOCTL_INMAGE_AT_LUN_CREATE              	_IOW(FLT_IOCTL,  AT_LUN_CREATE_CMD, LUN_CREATE_INPUT)
#define IOCTL_INMAGE_AT_LUN_DELETE              	_IOW(FLT_IOCTL,  AT_LUN_DELETE_CMD, LUN_DELETE_INPUT)
#define IOCTL_INMAGE_AT_LUN_LAST_WRITE_VI       	_IOWR(FLT_IOCTL, AT_LUN_LAST_WRITE_VI_CMD, AT_LUN_LAST_WRITE_VI)
#define IOCTL_INMAGE_AT_LUN_LAST_HOST_IO_TIMESTAMP   	_IOWR(FLT_IOCTL, AT_LUN_LAST_HOST_IO_TIMESTAMP_CMD, AT_LUN_LAST_HOST_IO_TIMESTAMP)
#define IOCTL_INMAGE_AT_LUN_QUERY               	_IOWR(FLT_IOCTL, AT_LUN_QUERY_CMD, LUN_QUERY_DATA)
#define IOCTL_INMAGE_GET_GLOBAL_STATS           	_IO(FLT_IOCTL, GET_GLOBAL_STATS_CMD)
#define IOCTL_INMAGE_GET_VOLUME_STATS           	_IO(FLT_IOCTL, GET_VOLUME_STATS_CMD)
#define IOCTL_INMAGE_GET_PROTECTED_VOLUME_LIST  	_IO(FLT_IOCTL, GET_PROTECTED_VOLUME_LIST_CMD)
#define IOCTL_INMAGE_GET_SET_ATTR               	_IOWR(FLT_IOCTL, GET_SET_ATTR_CMD, struct _inm_attribute *)
#define IOCTL_INMAGE_GET_ADDITIONAL_VOLUME_STATS 	_IOWR(FLT_IOCTL, GET_ADDITIONAL_VOLUME_STATS_CMD, VOLUME_STATS_ADDITIONAL_INFO)
#define IOCTL_INMAGE_GET_VOLUME_LATENCY_STATS		_IOWR(FLT_IOCTL, GET_VOLUME_LATENCY_STATS_CMD, VOLUME_LATENCY_STATS)
#define IOCTL_INMAGE_GET_VOLUME_BMAP_STATS       	_IOWR(FLT_IOCTL, GET_VOLUME_BMAP_STATS_CMD, VOLUME_BMAP_STATS)
#define IOCTL_INMAGE_SET_INVOLFLT_VERBOSITY		_IOWR(FLT_IOCTL, SET_INVOLFLT_VERBOSITY_CMD, inm_u32_t)
#define IOCTL_INMAGE_GET_MONITORING_STATS   		_IOWR(FLT_IOCTL, GET_MONITORING_STATS_CMD, MONITORING_STATS)
#define IOCTL_INMAGE_GET_BLK_MQ_STATUS   		_IOWR(FLT_IOCTL, GET_BLK_MQ_STATUS_CMD, int)
#define IOCTL_INMAGE_GET_VOLUME_STATS_V2  		_IOWR(FLT_IOCTL, GET_VOLUME_STATS_V2_CMD, TELEMETRY_VOL_STATS)
#define IOCTL_INMAGE_REPLICATION_STATE  		_IOWR(FLT_IOCTL, REPLICATION_STATE, replication_state_t)
#define IOCTL_INMAGE_NAME_MAPPING 			_IOWR(FLT_IOCTL, NAME_MAPPING, vol_name_map_t)
#define IOCTL_INMAGE_LCW 				_IOR(FLT_IOCTL, LCW, lcw_op_t)
#define IOCTL_INMAGE_WAIT_FOR_DB_V2              	_IOW(FLT_IOCTL, WAIT_FOR_DB_CMD_V2, WAIT_FOR_DB_NOTIFY)
#define IOCTL_INMAGE_INIT_DRIVER_FULLY			_IOW(FLT_IOCTL, INIT_DRIVER_FULLY_CMD, int)
#define IOCTL_INMAGE_COMMITDB_FAIL_TRANS              	_IOW(FLT_IOCTL, COMMITDB_FAIL_TRANS, COMMIT_DB_FAILURE_STATS)
#define IOCTL_INMAGE_GET_CXSTATS_NOTIFY               	_IOWR(FLT_IOCTL, GET_CXSTATS_NOTIFY, VM_CXFAILURE_STATS)
#define IOCTL_INMAGE_WAKEUP_GET_CXSTATS_NOTIFY_THREAD 	_IO(FLT_IOCTL, WAKEUP_GET_CXSTATS_NOTIFY_THREAD)
#define IOCTL_INMAGE_TAG_DRAIN_NOTIFY                 	_IOWR(FLT_IOCTL, TAG_DRAIN_NOTIFY, TAG_COMMIT_NOTIFY_OUTPUT)
#define IOCTL_INMAGE_WAKEUP_TAG_DRAIN_NOTIFY_THREAD   	_IO(FLT_IOCTL, WAKEUP_TAG_DRAIN_NOTIFY_THREAD)
#define IOCTL_INMAGE_MODIFY_PERSISTENT_DEVICE_NAME    	_IOW(FLT_IOCTL, MODIFY_PERSISTENT_DEVICE_NAME, MODIFY_PERSISTENT_DEVICE_NAME_INPUT)
#define IOCTL_INMAGE_GET_DRAIN_STATE                  	_IOWR(FLT_IOCTL, GET_DRAIN_STATE_CMD, GET_DISK_STATE_OUTPUT)
#define IOCTL_INMAGE_SET_DRAIN_STATE                  	_IOWR(FLT_IOCTL, SET_DRAIN_STATE_CMD, SET_DRAIN_STATE_OUTPUT)

#endif /* _IOCTL_H_ */
