# Command Line Usage

Once installed, `isort` exposes a command line utility for sorting, organizing, and formatting imports within Python and Cython source files.

To verify the tool is installed correctly, run `isort` from the command line and you should be given the available commands and the version of isort installed.
For a list of all CLI options type `isort --help` or view [the online configuration reference](https://pycqa.github.io/isort/docs/configuration/options):

<script id="asciicast-346599" src="https://asciinema.org/a/346599.js" async></script>

## Formatting a Project

In general, isort is most commonly utilized across an entire projects source at once. The simplest way to do this is `isort .` or if using a `src` directory `isort src`. isort will automatically find all Python source files recursively and pick-up a configuration file placed at the root of your project if present. This can be combined with any command line configuration customizations such as specifying a profile to use (`isort . --profile black`).

<script id="asciicast-346600" src="https://asciinema.org/a/346600.js" async></script>

## Verifying a Project

The second most common usage of isort is verifying that imports within a project are formatted correctly (often within the context of a CI/CD system). The simplest way to accomplish this is using the check command line option: `isort --check .`. To improve the usefulness of errors when they do occur, this can be combined with the diff option: `isort --check --diff .`.

<script id="asciicast-346601" src="https://asciinema.org/a/346601.js" async></script>

## Single Source Files

Finally, isort can just as easily be ran against individual source files. Simply pass in a single or multiple source files to sort or validate (Example: `isort setup.py`).

<script id="asciicast-346602" src="https://asciinema.org/a/346602.js" async></script>

## Multiple Projects

Running a single isort command across multiple projects, or source files spanning multiple projects, is highly discouraged. Instead it is recommended that an isort process (or command) is ran for each project independently. This is because isort creates an immutable config for each CLI instance.

```
# YES
isort project1
isort project2

# Also YES
isort project1/src project1/test
isort project2/src project2/test

# NO
isort project1 project2
```
